
<?php
date_default_timezone_set('America/Lima');
$fecha_actual = date('d/m/Y');
$hora_actual = date('H:i A');
$i = 1;
set_time_limit(180);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- <link href="{{ public_path('/css/pdf.css') }}" rel="stylesheet"> -->
    <title>Reporte generado</title>
    <style>
        html{
            margin: 0;
            padding: 25px 20px 15px 20px;
        }
        body {
            margin: 0;
            padding: 25px 20px 15px 20px;
            background:rgba(234, 234, 234, 0.188)
        }

        thead tr th{
            font-size: 0.3cm;
            text-align: center;
            border: 1px solid black;
            vertical-align: middle;
        }

        tbody tr td{
            font-size: 0.3cm;
            text-align: center;
            /* padding-left: 0.2cm; */
            border: 1px solid black;
        }

        tbody tr #text_n, #text_dni{
            text-align: center;
        }

        tbody tr #text_nombres, #text_tipodoc{
            padding-left: 5px;
            text-align: center;
        }

        tbody tr #text_nota{
            text-align: center;
        }


        /* ESTILOS PERSONALIZADOS POR ID */
        thead tr #thead_n{
            text-align: center;
            width: 0.5cm;
        }

        thead tr #thead-plan, #thead-periodo {
            text-align: center;
            width: 1.5cm;
        }

        thead tr #thead-codcurso, #thead-seccion, #thead-turno {
            text-align: center;
            width: 1.5cm;
        }

        thead tr #thead-creditos_horas {
            text-align: center;
            width: 2.5cm;
        }

        thead tr #thead-curso{
            text-align: center;
            max-width: 5cm;
        }


        #thead_nota {
            width: 1cm;
            text-align: center;
            vertical-align: middle;
            border: 1px solid black;
        }

        #contenedor{
            width: 100%;
            display: inline-block; /*Convertimos al menú en flexbox*/
            justify-content: center; /*Con esto le indicamos que margine todos los items que se encuentra adentro hacia la derecha e izquierda*/
            align-items: center;
        }

        #div_img {
            display: flex; /* Esto coloca los contenedores de las imágenes en línea */
            justify-content: space-between; /* Esto separa las imágenes a los extremos opuestos */
        }

        #logo1 {
            flex: 0 1 auto; /* Esto permite que el primer logo ocupe espacio según su tamaño */
        }

        #logo2 {
            flex: 0 1 auto; /* Esto permite que el segundo logo ocupe espacio según su tamaño */
        }

        #div_titulo {
            width: 100%;
            padding: 2px 2px 2px 2px;
        }

        #div_titulo #titulo_fechahora{
            width: 100%;
            text-align: right;
            font-size: 12px;
            font-weight: bold;
            font-family: "Times New Roman";
        }

        #div_titulo #div_titulo_reporte{
            width: 100%;
            text-align: center;
        }

        #titulo_reporte{
            font-size: 22px;
            font-family: "Times New Roman";
            font-weight: bold;
        }

        #div_contenido{
            width: 100%;
            margin-top: 5px;
            padding: 1px 1px 1px 1px;
        }
    </style>
</head>

<body>
    @auth
        {{-- USUARIO ADMIN --}}
        @if (Auth::User()->usertype_id == 1 ||
            Auth::User()->usertype_id == 2 ||
            Auth::User()->usertype_id == 3 ||
            Auth::User()->usertype_id == 4 ||
            Auth::User()->usertype_id == 5 ||
            Auth::User()->usertype_id == 6 ||
            Auth::User()->usertype_id == 7)
            <div id="contenedor">
                <div  id="div_contenido">
                    @foreach ($infos as $info)
                    {{-- <div id="div_img">
                        <div id="logo1">
                            <img src="{{ asset('images/institucion/logo.png') }}"  width="150px" height="100px" style="float: left;">
                        </div>
                        <div id="logo2">
                            <img src="{{ asset('images/institucion/minedu.jpg') }}" width="200px" height="40px" style="float: right;">
                        </div>
                        <br><br><br><br>
                    </div> --}}
                    <div id="div_titulo">
                        <div id="div_titulo_fechahora">
                            <p id="titulo_fechahora">Fecha: <?php echo $fecha_actual; ?>  Hora: <?php echo $hora_actual; ?></p>
                        </div>
                        <div id="div_titulo_reporte">
                            <p id="titulo_reporte">ACTA DE NOTAS POR ESTUDIANTE</p>
                            <p id="titulo_reporte"> Periodo {{ $info->semestre }}</p>
                        </div>
                    </div>
                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)">DRE-GRE:</td>
                                <td style="width: 60px;">{{ $institutions['dre'] }}</td>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)" >Institucion:</td>
                                <td style="width: 60px;">{{ $institutions['nombre'] }}</td>
                            </tr>
                            <tr>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)">Departamento:</td>
                                <td style="width: 60px;">{{ $institutions['departamento'] }}</td>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)">Provincia:</td>
                                <td style="width: 60px;">{{ $institutions['provincia'] }}</td>
                            </tr>
                            <tr>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)">Distrito:</td>
                                <td style="width: 50px;">{{ $institutions['distrito'] }}</td>
                                <td style="width: 40px; background-color: rgb(180, 180, 180)">Semestre:</td>
                                <td style="width: 50px;">{{ $info->semestre }}</td>
                            </tr>
                        </tbody>
                    </table>

                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="width: 40px; background-color: rgb(212, 238, 241)">Identificacion:</td>
                                <td style="width: 80px;">{{ $info->identificacion }}</td>
                                <td style="width: 40px; background-color: rgb(212, 238, 241)">Apellidos y nombres:</td>
                                <td style="width: 80px;">{{ $info->estudiante }}</td>
                            </tr>
                            <tr>
                                <td style="width: 40px; background-color: rgb(212, 238, 241)">Programa:</td>
                                <td style="width: 80px;">{{ $info->programa }}</td>
                                <td style="width: 40px; background-color: rgb(212, 238, 241)">Plan de estudios:</td>
                                <td style="width: 80px;">{{ $info->plan }}</td>
                            </tr>
                        </tbody>
                    </table>

                </div>
                @endforeach
                <table class="table">
                    <thead>
                        <tr>
                            <th id="thead_n">N°</th>
                            <th id="thead-plan">Plan</th>
                            <th id="thead-periodo">Periodo</th>
                            <th id="thead-codcurso">Código</th>
                            <th id="thead-curso">Nombre de la Ud. Didáctica</th>
                            <th id="thead-creditos_horas">Créditos y horas</th>
                            <th id="thead-seccion">Sección</th>
                            <th id="thead-turno">Turno</th>
                            <th id="thead-nota">Nota</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($asignaturas as $asignatura)
                        <tr>
                            <td id="text_n">{{ $i++ }}</td>
                            <td id="text_tipodoc">{{ $asignatura->plan }}</td>
                            <td id="text_tipodoc">{{ $asignatura->periodo }}</td>
                            <td id="text_tipodoc">{{ $asignatura->codcurso }}</td>
                            <td id="text_nrodoc">{{ $asignatura->curso }}</td>
                            <td id="text_tipodoc">{{ $asignatura->creditos_horas }}</td>
                            <td id="text_tipodoc">{{ $asignatura->seccion }}</td>
                            <td id="text_tipodoc">{{ $asignatura->turno }}</td>
                            <?php
                                $parteDecimal = $asignatura->promedio_final - floor($asignatura->promedio_final);

                                if ($parteDecimal >= 0.5) {
                            ?>
                                    <td id="text_nota">{{ ceil($asignatura->promedio_final) ?? '' }}</td>
                            <?php
                                } else {
                            ?>
                                    <td id="text_nota">{{ floor($asignatura->promedio_final) ?? '' }}</td>
                            <?php
                                }
                            ?>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    @endauth
</body>

</html>



