<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diploma de Egresado</title>
    <style>
        @page {
            size: landscape;
        }

        html {
            margin: 0;
            padding: 0;
            font-family: 'Aldhabi';
        }

        .header {
            width: 100%;
            position: relative;
            text-align: center;
        }

        .logo {
            position: absolute;
        }

        .logo.left {
            left: 40px; /* Espacio desde la izquierda */
            height: 60px; /* Tamaño fijo para las imágenes */
            top: 70px; /* Da espacio desde la parte superior */
        }

        .logo.right {
            right: 70px; /* Espacio desde la derecha */
            height: 100px; /* Tamaño fijo para las imágenes */
            top: 50px; /* Da espacio desde la parte superior */
            width: 80px;
        }

        .text-container {
            position: absolute;
            text-align: center;
            top: 70px;
            left: 300px;
        }

        .title {
            font-size: 20px;
            font-weight: bold;
        }

        .subtitle {
            font-size: 16px;
            margin: 0;
        }

        .subtitle {
            font-size: 16px;
            margin: 0;
        }

        .subtitle {
            font-size: 12px;
            margin: 0;
        }

        .content {
            position: absolute;
            top: 170px;
            text-align: center;
            width: 100%;
        }
        .diploma-title {
            font-size: 32px;
            color: blue;
            margin: 30px 0;
        }
        .student-name {
            font-size: 28px;
            margin: 30px 0;
        }
        .description {
            font-size: 20px;
            margin: 20px 0;
            line-height: 1.5;
        }
        .date {
            margin: 30px 0;
            text-align: right;
            padding-right: 100px;
        }

        .footer {
            position: absolute;
            bottom: 60px; /* Espacio desde la parte inferior */
            width: 100%;
            text-align: center;
        }

        .signatures {
            display: table;
            width: 100%;
            table-layout: fixed; /* Asegura que las columnas tengan un ancho fijo */
        }

        .signature {
            display: table-cell;
            vertical-align: top; /* Alinea las firmas en la parte superior */
            text-align: center;
            padding: 0 10px; /* Espacio horizontal entre las firmas */
        }

        .signature-line {
            border-top: 1px solid black;
            margin: 5px auto; /* Centra la línea dentro de cada celda */
            width: 80%; /* Ajusta el ancho de la línea */
        }

        .signature-title {
            font-size: 14px;
            font-weight: bold;
        }

    </style>
</head>
<body>
    <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: -1;">
        <img src="{{ public_path('images/institucion/fondo_diploma.png') }}" style="width: 100%; height: 100%; object-fit: cover;">
    </div>
    <div style="position: relative; z-index: 1;">
        <div class="header">
            <img class="logo left" src="{{ public_path('images/institucion/minedu.png') }}" alt="Logo Perú">
            <div class="text-container">
                <div class="title">MINISTERIO DE EDUCACIÓN</div>
                <div class="subtitle1">DIRECCIÓN REGIONAL DE EDUCACIÓN SUPERIOR</div>
                <div class="subtitle2" style="color: rgb(10,10,150)"><b>INSTITUTO DE EDUCACIÓN SUPERIOR TECNOLÓGICO PÚBLICO DE {{ $institutions['nombre'] }}</b></div>
                <div class="subtitle3">R.M. N° 702-87-ED - R.D. N° 057-2005-ED - Y CERTIFICADO N° 200 - 2013 - DIGESUTPA</div>
            </div>
            <img class="logo right" src="{{ public_path('images/institucion/logo.png') }}" alt="Logo Instituto">
        </div>

        <div class="content">
            <h2>POR CUANTO</h2>
            <p>La Dirección y Jefatura de Unidad Académica del Instituto de Educación Superior Tecnológico Público <br>
                 {{ $institutions['nombre'] }}, otorga el presente:</p>

            <div class="diploma-title"><b>DIPLOMA DE EGRESADO</b></div>

            <div class="student-name">{{ $estudiantes->estudiante }}</div>

            <div class="description">
                Por haber concluido satisfactoriamente los Seis Periodos Académicos correspondientes<br>
                al Programa de Estudio de {{ $estudiantes->programa }}, Promoción {{ $estudiantes->anho_ingreso }} - {{ $estudiantes->anho_ingreso + 2 }}.
            </div>

            <div class="date">
                Dado en la Ciudad de Casma, {{ $estudiantes->fecha_actual}}.
            </div>
        </div>
        <div class="footer">
            <div class="signatures">
                <div class="signature">
                    <div class="signature-line"></div>
                    <div class="signature-title">DIRECTOR GENERAL<br>I.E.S.T.P. {{ $institutions['nombre'] }}</div>
                </div>
                <div class="signature">
                    <div class="signature-line"></div>
                    <div class="signature-title">JEFE DE UNIDAD ACADEMICA<br>I.E.S.T.P. {{ $institutions['nombre'] }}</div>
                </div>
                <div class="signature">
                    <div class="signature-line"></div>
                    <div class="signature-title">COORD. DEL Programa<br>I.E.S.T.P. {{ $institutions['nombre'] }}</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
