
<?php
date_default_timezone_set('America/Lima');
$fecha_actual = date('d/m/Y');
$hora_actual = date('H:i A');
$i = 1;
set_time_limit(180);
?>

<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
<title>cursos por Periodo Lec.</title>

<style>
    html{
        margin: 0;
        padding: 25px 20px 15px 20px;
    }
    body {
        margin: 0;
        padding: 25px 20px 15px 20px;
        background:rgba(234, 234, 234, 0.188)
    }

    thead tr th{
        font-size: 0.3cm;
        text-align: center;
        border: 1px solid black;
        vertical-align: middle;
        background-color: rgb(212, 238, 241);
    }

    tbody tr td{
        font-size: 0.3cm;
        border: 1px solid black;
        vertical-align: middle;
    }

    /* ESTILOS PERSONALIZADOS POR ID */
    #thead_n{
        width: 0.5cm;
    }

    #thead_codcurso{
        width: 1.5cm;
    }

    #thead_curso{
        width: 5cm;
    }

    #text_n, #text_codcurso{
        text-align: center;
    }

    #text_cursos{
        width: 5cm;
        padding-left: 0.1cm;
        text-align: right;
    }

    #contenedor{
        width: 100%;
        display: inline-block; /*Convertimos al menú en flexbox*/
        justify-content: center; /*Con esto le indicamos que margine todos los items que se encuentra adentro hacia la derecha e izquierda*/
        align-items: center;
    }

    #div_img {
        display: flex; /* Esto coloca los contenedores de las imágenes en línea */
        justify-content: space-between; /* Esto separa las imágenes a los extremos opuestos */
    }

    #logo1 {
        flex: 0 1 auto; /* Esto permite que el primer logo ocupe espacio según su tamaño */
    }

    #logo2 {
        flex: 0 1 auto; /* Esto permite que el segundo logo ocupe espacio según su tamaño */
    }

    #div_titulo {
        width: 100%;
        padding: 2px 2px 2px 2px;
    }

    #div_titulo #titulo_fechahora{
        width: 100%;
        text-align: right;
        font-size: 12px;
        font-weight: bold;
        font-family: "Times New Roman";
    }

    #div_titulo #div_titulo_reporte{
        width: 100%;
        text-align: center;
    }

    #titulo_reporte{
        font-size: 22px;
        font-family: "Times New Roman";
        font-weight: bold;
    }

    #div_contenido{
        width: 100%;
        margin-top: 5px;
        padding: 1px 1px 1px 1px;
    }
</style>

</head>

<body>
@auth
    {{-- USUARIO ADMIN --}}
    @if (Auth::User()->usertype_id == 1)
        <div id="contenedor">
            <div  id="div_contenido">
                <div id="div_img">
                    <div id="logo1">
                        <img src="{{ asset('images/institucion/logo.png') }}"  width="150px" height="100px" style="float: left;">
                    </div>
                    <div id="logo2">
                        <img src="{{ asset('images/institucion/minedu.jpg') }}" width="200px" height="40px" style="float: right;">
                    </div>
                    <br><br><br><br>
                </div>
                <div id="div_titulo">
                    <div id="div_titulo_fechahora">
                        <p id="titulo_fechahora">Fecha: <?php echo $fecha_actual; ?>  Hora: <?php echo $hora_actual; ?></p>
                    </div>
                    @foreach ($estudiantes as $estudiante)
                    <div id="div_titulo_reporte">
                        <p id="titulo_reporte">ACTA OFICIAL CONSOLIDADA DE NOTAS</p>
                    </div>
                </div>
                <table class="table">
                    <tbody>
                        <tr>
                            <td style="width: 40px; background-color: rgb(212, 238, 241)">Numero de documento:</td>
                            <td style="width: 40px">{{ $estudiante->nroidenti }}</td>
                            <td style="width: 40px; background-color: rgb(212, 238, 241)">Apellidos y nombres:</td>
                            <td style="width: 80px">{{ $estudiante->estudiante }}</td>
                        </tr>
                    </tbody>
                </table>
                <br>
                <table class="table">
                    <tbody>
                        <tr>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">DRE-GRE:</td>
                            <td style="width: 40px">{{ $institutions['dre'] }}</td>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)" >Nombre:</td>
                            <td style="width: 80px">{{ $institutions['nombre'] }}</td>
                        </tr>
                        <tr>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Departamento:</td>
                            <td style="width: 40px">{{ $institutions['departamento'] }}</td>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Programa:</td>
                            <td style="width: 80px">{{ $estudiante->programa }}</td>
                        </tr>
                        <tr>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Provincia:</td>
                            <td style="width: 40px">{{ $institutions['provincia'] }}</td>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Nivel formativo:</td>
                            <td style="width: 80px">{{ $estudiante->nivel_formativo }}</td>
                        </tr>
                        <tr>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Distrito:</td>
                            <td style="width: 40px">{{ $institutions['distrito'] }}</td>
                            <td style="width: 40px; background-color: rgb(180, 180, 180)">Plan de estudios:</td>
                            <td style="width: 80px">{{ $estudiante->plan }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th id="thead_n">N°</th>
                        <th id="thead_codcurso">CODIGO</th>
                        <th id="thead_cursos">Unidad Didáctica</th>
                        <th id="">SEMESTRE</th>
                        <th id="">PERIODO</th>
                        <th id="">TIPO</th>
                        <th id="">CREDITOS</th>
                        <th id="">NOTA FINAL</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cursos as $curso)
                    <tr>
                        <td id="text_n">{{ $i++ }}</td>
                        <td id="text_codcurso">{{ $curso->codcurso }}</td>
                        <td id="text_curso">{{ $curso->curso }}</td>
                        <td id="text_n">{{ $curso->tipo }}</td>
                        <td id="text_n">{{ $curso->creditos }}</td>
                        <td id="text_n">{{ $curso->periodo }}</td>
                        <td id="text_n">{{ $curso->semestre }}</td>

                        <?php
                            if ($curso->nota != "NM") {

                                $parteDecimal = $curso->nota - floor($curso->nota);

                                if ($parteDecimal >= 0.5) {
                        ?>
                                    <td id="text_n">{{ ceil($curso->nota) ?? '' }}</td>
                        <?php
                                } else {
                        ?>
                                    <td id="text_n">{{ floor($curso->nota) ?? '' }}</td>
                        <?php
                                }
                            } else {
                        ?>
                                <td id="text_n">{{ $curso->nota }}</td>
                        <?php
                            }
                        ?>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
@endauth
</body>

</html>
