<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Constancia de Egresado</title>
    <style>
        @page {
            size: A4 portrait;
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            font-size: 12px;
            line-height: 1.5;
        }

        .container {
            width: 100%;
            margin: 0 auto;
            padding: 20px;
            position: relative;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .header .left-logo img {
            height: 60px;
        }

        .header .center-text {
            text-align: center;
            font-size: 14px;
        }

        .header .right-logo {
            text-align: right;
        }

        .header .right-logo img {
            height: 60px;
        }

        .institute-name {
            text-align: center;
            font-size: 18px;
            line-height: 1.5;
            margin-top: 80px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 16px;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        .content {
            text-align: justify;
            font-size: 14px;
        }

        .content .line {
            display: inline-block;
            border-bottom: 1px dotted #000;
            width: 300px;
        }

        .footer {
            text-align: left;
            margin-top: 30px;
        }

        .fecha {
            text-align: right;
            margin: 20px 0;
            font-size: 14px;
        }

        .signature {
            text-align: center;
            margin-top: 40px;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin: 0 auto;
        }

        .signature-title {
            font-weight: bold;
            margin-top: 5px;
            font-size: 12px;
        }

        .signature-subtitle {
            font-size: 10px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <div class="left-logo">
                <img src="{{ asset('/images/institucion/minedu.png') }}" alt="Logo del Ministerio">
            </div>
            <div class="center-text">
                <p>"Año del fortalecimiento de la soberanía nacional"</p>
            </div>
            <div class="right-logo">
                @if (!empty($logoSrc))
                    <img src="{{ $logoSrc }}" height="100">
                @endif
            </div>
        </div>

        <div class="title">CONSTANCIA DE EGRESADO</div>

        <p class="content">
            <strong>LA DIRECCIÓN DEL INSTITUTO DE EDUCACIÓN SUPERIOR TECNOLÓGICO</strong>
            {{ $institutions['nombre'] }}
            <br><br>
            HACE CONSTAR QUE:
            <br><br>
            El/la estudiante {{ $estudiantes->estudiante }}, identificado con DNI N° {{ $estudiantes->identificacion }},
            ha aprobado la totalidad de las cursos y experiencias formativas en situación real de trabajo, de acuerdo
            con el Plan de estudios
            del Programa de {{ $estudiantes->programa }}, correspondiente al nivel formativo de
            {{ $estudiantes->nivel }}.
            <br><br>
            Se extiende la presente conforme a lo precisado en el marco legal vigente establecido para los institutos de
            educación superior tecnológicos.
        </p>

        <div class="fecha">
            Lugar y fecha: {{ $institutions['direccion'] }}, {{ $estudiantes->fecha_actual }}
        </div>

        <div class="signature">
            <div class="signature-line"></div>
            <div class="signature-title">DIRECTOR GENERAL</div>
            <div class="signature-subtitle">(sello, firma, posfirma)</div>
        </div>
    </div>
</body>

</html>
