<?php
date_default_timezone_set('America/Lima');
set_time_limit(180);
?>
<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Certificado Modular</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 1.5cm;
        }

        body {
            font-family: helvetica, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            position: relative;
            /* Importante para el posicionamiento absoluto */
            min-height: 18cm;
        }

        .certificate {
            width: 100%;
            height: 100%;
            /* Asegurar que ocupe el alto */
        }

        /* --- Header Table (Logos superiores) --- */
        .header-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
            height: 80px;
        }

        .header-table td {
            vertical-align: middle;
            text-align: center;
        }

        .header-table .logo-cell {
            width: 25%;
            text-align: left;
        }

        .header-table .logo-cell-center {
            width: 50%;
            text-align: center;
        }

        .header-table .empty-cell {
            width: 25%;
            /* Mantenemos esta celda vacía para equilibrar y que el logo central siga al medio */
        }

        .header-table img {
            max-height: 70px;
            max-width: 100%;
            width: auto;
        }

        /* --- Contenido del Certificado --- */
        .institute-name {
            text-align: center;
            font-size: 18px;
            line-height: 1.5;
            margin-top: 20px;
            font-weight: bold;
        }

        .certificado-title {
            text-align: center;
            margin: 20px 0;
            font-weight: bold;
            font-size: 22px;
        }

        .content {
            margin: 15px 0;
            line-height: 1.5;
            font-size: 14px;
            text-align: justify;
        }

        .fecha {
            text-align: right;
            margin: 40px 0;
            font-size: 14px;
        }

        /* --- Firma (Centro Abajo) --- */
        .signature {
            text-align: center;
            width: 100%;
            position: absolute;
            left: 0;
            bottom: 40px;
            z-index: 10;
            /* Asegurar que quede por encima si hay cruce */
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin: 0 auto;
        }

        .signature-title {
            font-weight: bold;
            margin-top: 5px;
            font-size: 12px;
        }

        .signature-subtitle {
            font-size: 10px;
        }

        /* --- NUEVO: QR en la parte inferior izquierda --- */
        .qr-bottom-left {
            position: absolute;
            left: 0px;
            /* Pegado a la izquierda (respeta el margen del body) */
            bottom: 40px;
            /* Misma altura que la firma */
            width: 100px;
            /* Ancho fijo para el contenedor */
            text-align: center;
        }

        .qr-box {
            border: 1px solid #ccc;
            padding: 5px;
            display: inline-block;
            background: #fff;
        }
    </style>
</head>

<body>
    <div class="certificate">

        <table class="header-table">
            <tr>
                <td class="logo-cell">
                    @if (!empty($logoSrc))
                        <img src="{{ $logoSrc }}" alt="Logo Institución">
                    @endif
                </td>
                <td class="logo-cell-center">
                    @if (!empty($mineduLogoSrc))
                        <img src="{{ $mineduLogoSrc }}" alt="Logo MINEDU">
                    @endif
                </td>
                <td class="empty-cell"></td>
            </tr>
        </table>

        <div class="institute-name">
            Instituto de Educación Superior Tecnológico Público {{ $institutions['nombre'] }}
        </div>

        <div class="certificado-title">CERTIFICADO MODULAR</div>

        <div class="content">
            Otorgado a <strong>{{ $estudiantes->estudiante }}</strong>, identificado con
            <strong>{{ $estudiantes->identificacion }}</strong>, por haber aprobado satisfactoriamente el módulo
            formativo
            "<strong>{{ $estudiantes->descripcion }}</strong>", correspondiente al programa de estudios
            <strong>{{ $estudiantes->programa }}</strong>,
            desarrollado del <strong>{{ $estudiantes->fecha_ini }}</strong> hasta el
            <strong>{{ $estudiantes->fecha_fin }}</strong>, con un total de
            <strong>{{ $estudiantes->total_creditos }}</strong> créditos, equivalente a
            <strong>{{ $estudiantes->total_horas }}</strong> horas.
        </div>

        <div class="fecha">
            Lugar y fecha: {{ $institutions['direccion'] }}, {{ $estudiantes->fecha_actual }}
        </div>

        <div class="qr-bottom-left">
            <div class="qr-box">
                @if (!empty($qrCodeSrc))
                    <img src="{{ $qrCodeSrc }}" style="width: 80px; height: 80px; display:block;" alt="Código QR">
                @else
                    <span style="font-size: 9px; color: #999;">QR no disponible</span>
                @endif
            </div>
            <div style="font-size: 7px; color: #555; margin-top: 2px;">
                Verificar autenticidad
            </div>
        </div>

        <div class="signature">
            <div class="signature-line"></div>
            <div class="signature-title">DIRECTOR GENERAL</div>
            <div class="signature-subtitle">(sello, firma, posfirma)</div>
        </div>

    </div>
</body>

</html>
