<?php
date_default_timezone_set('America/Lima');
set_time_limit(180); // Aumenta el límite de tiempo a 120 segundos
?>


<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Certificado de Estudios</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 0.5cm;
        }

        body {
            font-family: Arial, sans-serif;
            padding: 0;
            margin: 0;
            font-size: 12px;
        }

        .certificate {
            width: 100%;
        }

        .header-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }

        .header-table td {
            vertical-align: middle;
            text-align: center;
        }

        .header-table .logo-cell {
            width: 20%;
        }

        .header-table .logo-cell-center {
            width: 60%;
        }

        .header-table .photo-cell {
            width: 20%;
            border: 1px solid #000;
            height: 100px;
        }

        .header-table img {
            max-height: 80px;
            max-width: 100%;
        }

        .header {
            width: 100%;
            height: 80px;
            position: relative;
            margin-bottom: 20px;
        }

        .logo-ies {
            /* border: 1px solid #000; */
            /* padding: 5px; */
            width: 100px;
            height: 50px;
            text-align: center;
            position: absolute;
            left: 0;
            font-size: 10px;
            top: 0;
        }

        .gov-logos {
            width: 300px;
            height: 60px;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: 0;
            text-align: center;
        }

        .photo-box {
            border: 1px solid #000;
            width: 80px;
            height: 100px;
            text-align: center;
            position: absolute;
            right: 0;
            top: 0;
        }

        .certificate-name {
            text-align: center;
            margin-top: 35px;
            font-size: 18px;
            line-height: 1.5;
        }

        .institute-name {
            text-align: left;
            /* margin-top: 15px; */
            font-size: 14px;
            line-height: 1.5;
        }

        .certifica {
            text-align: center;
            margin: 20px 0;
            font-weight: bold;
            font-size: 18px;
        }

        .content {
            margin: 15px 0;
            line-height: 1.5;
            font-size: 14px;
        }

        .table-container {
            overflow: visible;
            /* Permite que la tabla se extienda */
        }

        table {
            width: 100%;
            margin: 20px 0;
            font-size: 12px;
            border-collapse: collapse;
            /* page-break-inside: avoid; */
            page-break-inside: auto;
        }

        th,
        td {
            border: 0.5px solid #000;
            text-align: center;
            padding: 5px;
        }

        tr {
            page-break-inside: avoid;
        }

        .fecha {
            text-align: right;
            margin: 20px 0;
            font-size: 14px;
        }

        .signature {
            text-align: center;
            margin-top: 40px;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin: 0 auto;
        }

        .signature-title {
            font-weight: bold;
            margin-top: 5px;
            font-size: 16px;
        }

        .signature-subtitle {
            font-size: 13px;
        }

        * {
            font-family: helvetica, sans-serif;
        }

        /* .page-break {
            page-break-before: always;
        } */
    </style>
</head>

<body>
    <div class="certificate">
        <table class="header-table">
            <tr>
                <td class="logo-cell">
                    @if (!empty($logoSrc))
                        <img src="{{ $logoSrc }}">
                    @endif
                </td>
                <td class="logo-cell-center">
                    @if (!empty($mineduLogoSrc))
                        <img src="{{ $mineduLogoSrc }}" alt="Logo del Ministerio">
                    @endif
                </td>
                <td class="photo-cell">FOTO</td>
            </tr>
        </table>

        <div class="certificate-name">
            <b>CERTIFICADO DE ESTUDIOS DE EDUCACION SUPERIOR TECNOLOGICA</b><br>
            <p class="institute-name">El Instituto de Educación Superior Tecnológico Público de
                {{ $institutions['nombre'] }}
        </div>

        <div class="certifica">CERTIFICA</div>

        <div class="content">
            Que {{ $estudiantes->estudiante }} ha cursado las cursos,
            que se indican en el Programa: {{ $estudiantes->programa }}
        </div>

        <div class="content">
            El resultado final de las evaluaciones fue el siguiente:
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th class="text-center" width="40%" rowspan="2">cursos</th>
                        <th class="text-center" width="8%" rowspan="2">Créditos</th>
                        <th class="text-center" colspan="2">Nota</th>
                        <th class="text-center" width="8%" rowspan="2">Periodo Lec.</th>
                        <th class="text-center" width="10%" rowspan="2">Año</th>
                        <th class="text-center" width="8%" rowspan="2">Semestre</th>
                        <th class="text-center" width="10%" rowspan="2">Observación</th>
                    </tr>
                    <tr>
                        <th width="8%">En números</th>
                        <th width="8%">En letras</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cursos as $curso)
                        <tr>
                            <td>{{ $curso->nombre_curso }}</td>
                            <td class="text-center">{{ $curso->creditos }}</td>
                            <td class="text-center">{{ $curso->nota_numero }}</td>
                            <td class="text-center">{{ $curso->nota_letras }}</td>
                            <td class="text-center">{{ $curso->semestre }}</td>
                            <td class="text-center">{{ $curso->fecha_semestre }}</td>
                            <td class="text-center">{{ $curso->periodo }}</td>
                            <td></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="fecha">
                Lugar y fecha: {{ $institutions['direccion'] }}, {{ $estudiantes->fecha_actual }}
            </div>

            <div class="signature">
                <div class="signature-line"></div>
                <div class="signature-title">DIRECTOR GENERAL</div>
                <div class="signature-subtitle">(sello, firma, posfirma)</div>
            </div>
        </div>
    </div>
</body>

</html>
