<?php
date_default_timezone_set('America/Lima');
$fecha_actual = date('d/m/Y');
$hora_actual = date('H:i A');
$i = 1;
set_time_limit(180);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <title>Boleta de Pago</title>
    <style>
        * {
            margin: 0;
            padding: 0;
        }

        body {
            margin-top: 1cm;
            margin-left: 0.5cm;
            margin-right: 0.5cm;
            font-family: 'Arial', sans-serif;
            font-size: 0.35cm;
            /* width: 8cm; */
            /* text-align: center; */
        }

        #table_montos .monto {
            font-size: 0.30cm;
            text-align: right;
        }

        #titulo_fechahora {
            text-align: right;
        }

        #titulo_reporte {
            text-align: center;
            margin: 0;
        }
    </style>
</head>

<body>
    @auth
        {{-- USUARIO ADMIN --}}
        @if (Auth::User()->usertype_id == 1 ||
                Auth::User()->usertype_id == 2 ||
                Auth::User()->usertype_id == 3 ||
                Auth::User()->usertype_id == 4 ||
                Auth::User()->usertype_id == 5 ||
                Auth::User()->usertype_id == 6 ||
                Auth::User()->usertype_id == 7)
            @foreach ($infos as $info)
            
                <div>
                    <p id="titulo_fechahora">{{ $info->fecha2  }}</p>
                    <br>
                    <p id="titulo_reporte">BOLETA DE PAGO {{ str_pad($info->idpago, 8, '0', STR_PAD_LEFT)  }}</p>
                    <br><br>
                    <div id="div_institucion">
                        <p>DRE: {{ $institutions['dre'] }}</p>
                        <p>Institucion: {{ $institutions['nombre'] }}</p>
                        <p>Programa: {{ $info->programa }}</p>
                    </div>
                    <div id="div_detalles">
                        <p>Concepto: {{ $info->nombreconcepto }}</p>
                        <p>Método de pago: {{ $info->nombremetodopago }}</p>
                        <p>Estudiante: {{ $info->estudiante }}</p>
                        <p>Identificación: {{ $info->identificacion }} </p>
                    </div>
                    {{-- <div id="div_estudiante">
                        <p>Estudiante: {{ $info->estudiante }}</p>
                        <p>Identificación: {{ $info->identificacion }} </p>
                    </div> --}}
                    <br>
                    <table id="table_montos">
                        <tr>
                            <td>Monto Inicial:</td>
                            <td class="monto">S/. {{ number_format($info->monto_inicial, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Descuento:</td>
                            <td class="monto">S/. {{ number_format($info->descuento, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Monto Final:</td>
                            <td class="monto">S/. {{ number_format($info->monto_final, 2) }}</td>
                        </tr>
                    </table>
                </div>
            @endforeach
        @endif
    @endauth
</body>

</html>
