
<?php
    date_default_timezone_set('America/Lima');
    $fecha_actual = date('d/m/Y');
    $hora_actual = date('H:i A');
    $i = 1;
    set_time_limit(180);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- <link href="{{ public_path('/css/pdf.css') }}" rel="stylesheet"> -->
    <title>Acta Auxiliar de Notas</title>
    <style>
        html{
            margin: 0;
            padding: 25px 20px 15px 20px;
        }

        body {
            margin: 0;
            padding: 25px 20px 15px 20px;
            background:rgba(234, 234, 234, 0.188)
        }

        thead tr th{
            font-size: 0.3cm;
            text-align: center;
            border: 1px solid black;
            vertical-align: middle;
        }

        tbody tr td{
            font-size: 0.3cm;
            padding-left: 0.2cm;
            border: 1px solid black;
        }

        tbody tr #text_n, #text_dni{
            text-align: center;
            font-size: 0.6rem;
        }

        tbody tr #text_nombres{
            padding-left: 5px;
            font-size: 0.6rem;
        }

        tbody tr #text_nota{
            text-align: center;
        }


        /* ESTILOS PERSONALIZADOS POR ID */
        thead tr #thead_n{
            text-align: center;
            width: 0.5cm;
        }

        thead tr #thead_tipodoc{
            text-align: center;
            width: 1.2cm;
        }


        thead tr #thead_nombres{
            /* max-width: 5cm; */
        }


        #thead_nota {
            width: 1cm;
            text-align: center;
            vertical-align: middle;
            border: 1px solid black;
            font-size: 0.5rem;
        }

        #contenedor{
            width: 100%;
            display: inline-block; /*Convertimos al menú en flexbox*/
            justify-content: center; /*Con esto le indicamos que margine todos los items que se encuentra adentro hacia la derecha e izquierda*/
            align-items: center;
        }

        #div_img {
            display: flex; /* Esto coloca los contenedores de las imágenes en línea */
            justify-content: space-between; /* Esto separa las imágenes a los extremos opuestos */
        }

        #logo1 {
            flex: 0 1 auto; /* Esto permite que el primer logo ocupe espacio según su tamaño */
        }

        #logo2 {
            flex: 0 1 auto; /* Esto permite que el segundo logo ocupe espacio según su tamaño */
        }

        #div_titulo {
            width: 100%;
            padding: 2px 2px 2px 2px;
        }

        #div_titulo #titulo_fechahora{
            width: 100%;
            text-align: right;
            font-size: 12px;
            font-weight: bold;
            font-family: "Times New Roman";
        }

        #div_titulo #div_titulo_reporte{
            width: 100%;
            text-align: center;
        }

        #titulo_reporte{
            font-size: 22px;
            font-family: "Times New Roman";
            font-weight: bold;
        }

        #div_contenido{
            width: 100%;
            margin-top: 5px;
            padding: 1px 1px 1px 1px;
        }
    </style>
</head>

<body>
    @auth
        {{-- USUARIO ADMIN --}}
        @if (Auth::User()->usertype_id == 1 ||
            Auth::User()->usertype_id == 2 ||
            Auth::User()->usertype_id == 4 ||
            Auth::User()->usertype_id == 5 ||
            Auth::User()->usertype_id == 6 ||
            Auth::User()->usertype_id == 7)
            <div id="contenedor">
                <div  id="div_contenido">
                    @foreach ($infos as $info)
                    {{-- <div id="div_img">
                        <div id="logo1">
                            <img src="{{ asset('images/institucion/logo.png') }}"  width="150px" height="100px" style="float: left;">
                        </div>
                        <div id="logo2">
                            <img src="{{ asset('images/institucion/minedu.jpg') }}" width="200px" height="40px" style="float: right;">
                        </div>
                        <br><br><br><br>
                    </div> --}}
                    <div>
                        <img src="data:image/png;base64, {!!  $qrCode !!}" alt="Imagen QR" width="100px" height="100px" style="float: left;">
                    </div>

                    <div id="div_titulo">
                        <div id="div_titulo_fechahora">
                            <p id="titulo_fechahora">Fecha: <?php echo $fecha_actual; ?>  Hora: <?php echo $hora_actual; ?></p>
                        </div>
                        <div id="div_titulo_reporte">
                            <p id="titulo_reporte">ACTA AUXILIAR DE NOTAS </p>
                            <p id="titulo_reporte"> Periodo {{ $info->semestre }}</p>
                        </div>
                    </div>

                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">DRE-GRE:</td>
                                <td style="width: 60px;">{{ $institutions['dre'] }}</td>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)" >Nombre:</td>
                                <td style="width: 60px;">{{ $institutions['nombre'] }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Departamento:</td>
                                <td style="width: 60px;">{{ $institutions['departamento'] }}</td>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Programa:</td>
                                <td style="width: 60px;">{{ $info->programa }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Provincia:</td>
                                <td style="width: 60px;">{{ $institutions['provincia'] }}</td>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Nivel formativo:</td>
                                <td style="width: 60px;">{{ $info->nivel_formativo }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Distrito:</td>
                                <td style="width: 60px;">{{ $institutions['distrito'] }}</td>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Periodo de clases:</td>
                                <td style="width: 60px;">{{ $info->semestre }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Semestre Académico:</td>
                                <td style="width: 60px;">{{ $info->periodo }}</td>
                                <td style="width: 50px; background-color: rgb(180, 180, 180)">Plan de estudios:</td>
                                <td style="width: 60px;">{{ $info->plan }}</td>
                            </tr>
                        </tbody>
                    </table>

                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="width: 50px; background-color: rgb(212, 238, 241)">Codigo curso:</td>
                                <td style="width: 60px;">{{ $info->codcurso }}</td>
                                <td style="width: 50px; background-color: rgb(212, 238, 241)">Nombre curso:</td>
                                <td style="width: 60px;">{{ $info->curso }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                @endforeach

                <table class="table">
                    <thead>
                        <tr>
                            <th id="thead_n" rowspan="2">N°</th>
                            <th id="thead_tipodoc" rowspan="2">DNI</th>
                            <th id="thead_nombres" rowspan="2">Nombre del estudiante</th>
                            @foreach ($actividad_notas as $actividad_nota)
                                <th id="thead_nota" colspan="{{ $actividad_nota->contador }}" style="background-color: #ffffff">{{ $actividad_nota->actividad }}</th>
                                @if ($actividad_nota->estado == "1")
                                    <th id="thead_nota" rowspan="2" style="background-color: #d5d5d5">{{ $actividad_nota->indicador }}</th>
                                @endif
                            @endforeach
                            <th id="thead_nota" rowspan="2" style="background-color: #ff6161">Nota Final</th>
                        </tr>
                        <tr>
                            @foreach ($notas as $nota)
                                <th id="thead_nota">{{ $nota->nota }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                        @php
                            $student = 0;
                        @endphp
                        @foreach ($estudiantes as $i => $estudiante)

                            @if ($student == $estudiante->idstudent)

                                @if ($estudiante->estado_promfinal == "0")

                                    @if ($estudiante->estado_indicador == "0")

                                        <td id="text_nota">{{ $estudiante->nota_estudiante }}</td>

                                    @elseif ($estudiante->estado_indicador == "1")

                                        <td id="text_nota">{{ $estudiante->nota_estudiante }}</td>
                                        <td id="text_nota">{{ $estudiante->prom_indicador }}</td>

                                    @endif

                                @elseif ($estudiante->estado_promfinal == "1")

                                        <td id="text_nota">{{ $estudiante->nota_estudiante }}</td>
                                        <td id="text_nota">{{ $estudiante->prom_indicador }}</td>
                                        <td id="text_nota">{{ $estudiante->prom_final }}</td>
                                    </tr>

                                @endif
                            @else

                                @php
                                    $student = $estudiante->idstudent;
                                @endphp
                                <tr>
                                <td id="text_n">{{ $i + 1 }}</td>
                                <td id="text_dni">{{ $estudiante->identificacion }}</td>
                                <td id="text_nombres">{{ $estudiante->estudiante }}</td>
                                <td id="text_nota">{{ $estudiante->nota_estudiante }}</td>

                            @endif

                        @endforeach
                        </tr>
                    </tbody>
                </table>

            </div>
        @endif
    @endauth
</body>

</html>



