    <!--**********************************
                Sidebar start
        ***********************************-->
    <div class="dlabnav">
        <div class="dlabnav-scroll">
            @auth
                @php
                    $user = Auth::user();
                @endphp

                <ul class="metismenu" id="menu">




                        {{-- USUARIO ADMIN --}}
                        @if ($loggedUserType == 'admin' && $user->administradores()->exists())
                            {{-- MENU --}}
                            <li class="p-1"><a href="{{ route('home.adm.dashboard') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">home</i>
                                    <span class="nav-text">Panel</span>
                                </a>
                            </li>
                            {{-- USUARIO ADMIN --}}
                            @foreach ($datalistService as $item)
                                <li class="p-1">
                                    <a class="has-arrow" href="javascript:void(0);" aria-expanded="false">
                                        <i class="material-symbols-outlined">{{ $item['icon'] }}</i>
                                        <span class="nav-text">{{ $item['name'] }}</span>
                                    </a>
                                    {{-- submenu --}}
                                    <ul aria-expanded="false">
                                        @foreach ($item['submenu'] as $submenu)
                                            <?php if ($submenu['route'] === "admin.seguimiento_egresado.sistema_conecta") { ?>
                                            <li><a href="{{ route($submenu['route']) }}"
                                                    target="_blank">{{ $submenu['name'] }}</a></li>
                                            <?php  } else  { ?>
                                            <li><a href="{{ route($submenu['route']) }}">{{ $submenu['name'] }}</a></li>
                                            <?php } ?>
                                        @endforeach
                                    </ul>
                                </li>
                            @endforeach





                        {{-- USUARIO DOCENTE --}}
                        @elseif ($loggedUserType == 'teacher' && $user->teachers()->exists())
                            {{-- MENU --}}
                            <li class="p-1"><a href="{{ route('home.docente.index') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">home</i>
                                    <span class="nav-text">Inicio</span>
                                </a>
                            </li>
                            {{-- USUARIO ADMIN --}}
                            {{-- DOCENTE - MENU --}}
                            <li class="p-1"><a href="{{ route('docente.horarios') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">calendar_month</i>
                                    <span class="nav-text">Horarios</span>
                                </a>
                            </li>
                            <li class="px-1"><a href="{{ route('docente.asistencias') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined" style="font-size: 1.5rem">badge</i>
                                    <span class="nav-text">Control de Asistencias</span>
                                </a>
                            </li>
                            <li class="px-1"><a href="{{ route('docente.materiales_recursos') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined" style="font-size: 1.5rem">folder</i>
                                    <span class="nav-text">Materiales y recursos</span>
                                </a>
                            </li>
                            <li class="px-1"><a href="{{ route('docente.foros') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined" style="font-size: 1.5rem">forum</i>
                                    <span class="nav-text">Foros</span>
                                </a>
                            </li>
                            <li class="px-1">
                                <a href="{{ route('docente.zoom.index') }}" aria-expanded="false">
                                    <i class="bi bi-camera-video-fill" style="font-size: 1.5rem"></i>
                                    <span class="nav-text">Reuniones Zoom</span>
                                </a>
                            </li>
                            <li class="p-1">
                                <a class="has-arrow" href="javascript:void(0);" aria-expanded="false">
                                    <i class="material-symbols-outlined">grade</i>
                                    <span class="nav-text">Gestion de Notas</span>
                                </a>
                                {{-- submenu --}}
                                <ul aria-expanded="false">
                                    <li><a href="{{ route('docente.notas.gestionar_indicadores') }}">Gestionar Indicadores</a>
                                    </li>
                                    {{-- <li><a href="{{ route('docente.notas.gestionar_notas') }}">Subir Notas</a></li> --}}
                                    <li><a href="{{ route('docente.notas.promedios') }}">Promedios</a></li>
                                </ul>
                            </li>
                            <li class="p-1">
                                <a href="{{ route('tramite_documentario.registrar') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">folder</i>
                                    <span class="nav-text">Trámite Documentario</span>
                                </a>
                            </li>
                            <li class="p-1">
                                <a href="{{ route('docente.ofertas_laborales') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">work</i>
                                    <span class="nav-text">Bolsa Laboral</span>
                                </a>
                            </li>
                            {{-- <li class="p-1">
                                <a href="{{ route('docente.citas_presenciales.gestionar') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">perm_contact_calendar</i>
                                    <span class="nav-text">Citas Presenciales</span>
                                </a>
                            </li> --}}
                            <li class="p-1">
                                <a href="{{ route('docente.publicaciones.index') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">poll</i>
                                    <span class="nav-text">Publicaciones</span>
                                </a>
                            </li>
                            <li class="p-1">
                                <a href="{{ route('docente.requisitos.index') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">assignment_turned_in</i>
                                    <span class="nav-text">Requisitos de Docente</span>
                                </a>
                            </li>
                            {{-- <li class="p-1">
                                <a href="{{ route('docente.semanas.index') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">date_range</i>
                                    <span class="nav-text">Gestión de Semanas</span>
                                </a>
                            </li> --}}






                        {{-- USUARIO Estudiante --}}
                        @elseif ($loggedUserType == 'student' && $user->students()->exists())
                            {{-- MENU --}}
                            <li class="p-1"><a href="{{ route('home.student.index') }}" aria-expanded="false">
                                    <i class="material-symbols-outlined">home</i>
                                    <span class="nav-text">Inicio</span>
                                </a>
                            </li>
                            {{-- Estudiante - MENU --}}
                            @if (Auth::user()->students->isNotEmpty())


                                @if (Auth::user()->students[0]->estado == 1 && Auth::user()->students[0]->estado != 0)
                                    <li class="p-1"><a href="{{ route('alumno.matricula') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">history_edu</i>
                                            <span class="nav-text">Matrícula</span>
                                        </a>
                                    </li>
                                    <li class="p-1"><a href="{{ route('alumno.horarios') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">calendar_month</i>
                                            <span class="nav-text">Horarios</span>
                                        </a>
                                    </li>
                                    <li class="px-1">
                                        <a href="{{ route('alumno.asistencias') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined" style="font-size: 1.5rem">badge</i>
                                            <span class="nav-text">Asistencias</span>
                                        </a>
                                    </li>
                                    <li class="px-1"><a href="{{ route('alumno.materiales_recursos') }}"
                                            aria-expanded="false">
                                            <i class="material-symbols-outlined" style="font-size: 1.5rem">folder</i>
                                            <span class="nav-text">Materiales y recursos</span>
                                        </a>
                                    </li>
                                    <li class="px-1"><a href="{{ route('alumno.foros') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined" style="font-size: 1.5rem">forum</i>
                                            <span class="nav-text">Foro</span>
                                        </a>
                                    </li>
                                    <li class="px-1"><a href="{{ route('alumno.tareas') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">assignment</i>
                                            <span class="nav-text">Tareas</span>
                                        </a>
                                    </li>
                                    <li class="p-1"><a href="{{ route('alumno.notas') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">money</i>
                                            <span class="nav-text">Notas</span>
                                        </a>
                                    </li>
                                    <li class="p-1">
                                        <a href="{{ route('alumno.pagos') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">payments</i>
                                            <span class="nav-text">Pagos</span>
                                        </a>
                                    </li class="p-1">
                                    <li class="p-1"><a href="{{ route('alumno.publicaciones') }}" aria-expanded="false">
                                            <i class="material-symbols-outlined">star</i>
                                            <span class="nav-text">Publicaciones</span>
                                        </a>
                                    </li>
                                    <li class="p-1">
                                        <a class="has-arrow" href="javascript:void(0);" aria-expanded="false">
                                            <i class="material-symbols-outlined">work</i>
                                            <span class="nav-text">Bolsa Laboral</span>
                                        </a>
                                        {{-- submenu --}}
                                        <ul aria-expanded="false">
                                            <li><a href="{{ route('alumno.ofertas_laborales') }}" aria-expanded="false">
                                                    <span class="nav-text">Ofertas Laborales</span>
                                                </a>
                                            </li>
                                            <li><a href="{{ route('alumno.postulaciones') }}" aria-expanded="false">
                                                    <span class="nav-text">Postulaciones</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    {{-- RUTA PARA TODOS --}}
                                    <li class="p-1">
                                        <a class="has-arrow" href="javascript:void(0);" aria-expanded="false">
                                            <i class="material-symbols-outlined">folder</i>
                                            <span class="nav-text">Trámite Docum.</span>
                                        </a>
                                        {{-- submenu --}}
                                        <ul aria-expanded="false">
                                            {{-- <li><a href="{{ route('tramite_documentario.mis_tramites') }}" aria-expanded="false">
                                                <span class="nav-text">Mis Trámites</span>
                                            </a>
                                        </li> --}}
                                            <li><a href="{{ route('tramite_documentario.registrar') }}"
                                                    aria-expanded="false">
                                                    <span class="nav-text">Registrar</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>






                                @elseif (Auth::user()->students[0]->estado == 2)
                                    <li class="p-1">
                                        <a class="has-arrow" href="javascript:void(0);" aria-expanded="false">
                                            <i class="material-symbols-outlined">trending_up</i>
                                            <span class="nav-text">Seguimiento al Egresado</span>
                                        </a>
                                        {{-- submenu --}}
                                        <ul aria-expanded="false">
                                            <li><a href="#">Documentos de Titulación</a></li>
                                        </ul>
                                    </li>
                                @endif








                            @endif
                        @endif
                </ul>
            @endauth
            {{-- copyright --}}
            {{-- <div class="copyright">
                <p><strong>Sistema de Gestión Académica</strong></p>
                <p class="fs-12">Hecho con <span class="heart"></span> por Silfersystem</p>
            </div> --}}
        </div>
    </div>
    <!--**********************************
                Sidebar end
    ***********************************-->
