<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Inicio Estudiante</title>
    @include('include.datatable-styles')
    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Inicio') }}
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">

                    @csrf
                    <div class="col-xl-8">
                        <div class="card h-auto">
                            <div class="card-header p-0">
                                <div class="user-bg w-100">
                                    <div class="user-svg">
                                        <svg width="264" height="109" viewBox="0 0 264 109" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect x="0.0107422" y="0.6521" width="263.592" height="275.13"
                                                rx="20" fill="#FCC43E" />
                                        </svg>
                                    </div>
                                    <div class="user-svg-1">
                                        <svg width="264" height="59" viewBox="0 0 264 59" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect y="0.564056" width="263.592" height="275.13" rx="20"
                                                fill="#FB7D5B" />
                                        </svg>

                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="user">
                                        <div class="user-media">
                                            @if (Auth::User()->genre_id == 1)
                                                <img src="{{ asset('/images/avatar/maleStudent.jpg') }}" alt=""
                                                    class="avatar avatar-xxl">
                                            @elseif (Auth::User()->genre_id == 2)
                                                <img src="{{ asset('/images/avatar/femaleStudent.jpg') }}"
                                                    alt="" class="avatar avatar-xxl">
                                            @else
                                                <img src="{{ asset('/images/avatar/other.jpg') }}" alt=""
                                                    class="avatar avatar-xxl">
                                            @endif
                                        </div>
                                        <div>
                                            <h2 class="mb-0">{{ Auth::User()->nombres }}</h2>
                                            <p class="text-primary font-w600">Estudiante</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-xl-6 col-xxl-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/profile.svg') }}" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Apellidos:</span>
                                                <h5 class="mb-0">{{ Auth::User()->nombres }}
                                                    {{ Auth::User()->apellido_pa }} - {{ Auth::User()->apellido_ma }}
                                                </h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xl-6 col-xxl-6 col-sm-6 my-1">

                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/location.svg') }}" alt="">
                                                </a>

                                            </li>
                                            <li><span>Dirección:</span>
                                                <h5 class="mb-0">{{ Auth::User()->direccion }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xl-6 col-xxl-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/phone.svg') }}" alt="">
                                                </a>
                                            </li>
                                            <li><span>Celular:</span>
                                                <h5 class="mb-0">{{ Auth::User()->celular }} -
                                                    {{ Auth::User()->telefono }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xl-6 col-xxl-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/email.svg') }}" alt="">
                                                </a>

                                            </li>
                                            <li><span>Correo:</span>
                                                <h5 class="mb-0">{{ Auth::User()->correo }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="card">
                            <div class="card-header border-0 pb-2 justify-content-center bg-primary">
                                <h4 class="card-title text-light">cursos <span id="total_asign"></span></h4>
                            </div>
                            <div class="card-body p-0">
                                <div id="DZ_W_TimeLine11"
                                    class="widget-timeline dlab-scroll height370 style-1 my-4 px-2">
                                    <ul class="timeline" id="list_asignaturas">

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-12 col-sm-12">
                        <div class="card" id="accordion-three">
                            <div class="card-header flex-wrap px-3">
                                <div>
                                    <h4 class="card-title">Historial de cursos del estudiante</h4>
                                </div>
                            </div>
                            <!-- /tab-content -->
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                    aria-labelledby="home-tab-2">
                                    <div class="card-body p-4">
                                        <div class="table-responsive">
                                            <table id="datatableGeneral"
                                                class="table table-hover table-bordered table-sm display rounded-3"
                                                style="min-width:100%">
                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Periodo Lec.</th>
                                                        <th class="text-center">Semestre</th>
                                                        <th class="text-center">Código</th>
                                                        <th class="text-center">Ud. Didáctica</th>
                                                        <th class="text-center">Docente</th>
                                                        <th class="text-center">Seccion</th>
                                                        <th class="text-center">Turno</th>
                                                        <th class="text-center">Créditos</th>
                                                        <th class="text-center">Horas</th>
                                                        <th class="text-center">Silabo</th>
                                                        <th class="text-center">Inst. Evaluación</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!--  -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- /tab-content -->
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!--**********************************
            Content body end
        ***********************************-->

        @include('include.footer')




    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.modal-versiones')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/alumno/home_student.js'])

    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
