<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Panel</title>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        /* Cambia el color del texto del menú de ApexCharts */
        .apexcharts-menu-item {
            color: #000 !important;
            /* negro */
        }

        /* (Opcional) cambia el color de fondo del menú si lo deseas */
        .apexcharts-menu {
            background-color: #fff !important;
            /* blanco */
            border: 1px solid #ddd !important;
        }

        /* (Opcional) cambia el hover */
        .apexcharts-menu-item:hover {
            background-color: #f1f1f1 !important;
        }
    </style>

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->

    <div id="main-wrapper">

        @include('include.nav_header')

        {{-- @include('include.header', ['titlenavbar' => __('Panel')]) --}}
        @extends('include.header')
        @section('titlenavbar')
            {{ __('Panel') }}
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <form id="form">
            @csrf
            <input type="hidden" id="op" name="op" value="1">
            <div class="content-body">
                <div class="container-fluid">
                    <div class="row">

                        {{-- stats - inicio --}}
                        @include('home.adm.dashboard.stats')
                        {{-- stats - fin --}}
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Recaudación por Meses</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="recaudacion_meses"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Recaudación por Conceptos</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="recaudacion_conceptos"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Estudiantes por Programas</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="estudiantes_programas"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Egresados por Año</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="egresados_anho"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- <div class="col-xl-4 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Conoce nuestra bolsa laboral!!!
                                        </h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content m-1 p-1 text-center">
                                    <div class="text-center logo">
                                        <img src="{{ asset('/images/institucion/bolsa_laboral.jpg') }}" alt=""
                                            width="100%" height="20%">
                                    </div>
                                    <br>
                                    <a href="{{ route('admin.bolsa_laboral.ofertas_laborales') }}"
                                        class="btn btn-primary">
                                        Click en este Link
                                    </a>
                                </div>
                            </div>
                        </div> --}}

                    </div>
                </div>
            </div>
        </form>

        <!--**********************************
            Content body end
        ***********************************-->

        @include('include.footer')

    </div>


    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')


    @include('include.modal-versiones')


    @include('include.datatable-scripts')

    <!-- Dashboard -->
    <script src="{{ asset('/vendor/chart.js/Chart.bundle.min.js') }}"></script>
    {{-- <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script> --}}
    <script src="{{ asset('/vendor/apexchart/apexchart.js') }}"></script>
    <script src="{{ asset('/vendor/wow-master/dist/wow.min.js') }}"></script>
    <script src="{{ asset('/js/dashboard/dashboard-2.js') }}"></script>

    @vite(['resources/js/admin/dashboard/main.js'])
    @vite(['resources/js/admin/dashboard/recaudacion-meses.js'])
    @vite(['resources/js/admin/dashboard/recaudacion-conceptos.js'])
    @vite(['resources/js/admin/dashboard/estudiantes-programas.js'])
    @vite(['resources/js/admin/dashboard/egresados-anho.js'])

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

</body>

</html>
