<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reuniones de Zoom</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Agregar el CSS de Toastify -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

    <!-- Agregar el JS de Toastify -->
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Reuniones de Zoom
        @endsection

        @include('include.sidebar')
        <div class="content-body">
            <div class="container-fluid pt-0">
                <div class="container mt-4">

                    <div class="alert" id="message" style="display: none;">
                        @if (session('success'))
                            <script>
                                Toastify({
                                    text: "{{ session('success') }}",
                                    backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)", // Color verde
                                    className: "info",
                                    duration: 3000 // Duración en milisegundos
                                }).showToast();
                            </script>
                        @endif

                        @if (session('error'))
                            <script>
                                Toastify({
                                    text: "{{ session('error') }}",
                                    backgroundColor: "linear-gradient(to right, #ff5f6d, #ffc3a0)", // Color rojo
                                    className: "error",
                                    duration: 5000 // Duración más larga para mostrar el error
                                }).showToast();
                            </script>
                        @endif
                    </div>

                    <!-- Formulario para crear una nueva reunión -->
                    <h3>Crear Nueva Reunión</h3>
                    <form action="{{ route('zoom.meetings.create') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="topic" class="form-label">Tema</label>
                            <input type="text" name="topic" id="topic" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="start_time" class="form-label">Hora de inicio</label>
                            <input type="datetime-local" name="start_time" id="start_time" class="form-control"
                                required>
                        </div>
                        <div class="mb-3">
                            <label for="duration" class="form-label">Duración (minutos)</label>
                            <input type="number" name="duration" id="duration" class="form-control" value="60"
                                required>
                        </div>
                        <button type="submit" class="btn btn-primary">Crear Reunión</button>
                    </form>

                    <!-- Pestañas -->
                    <div class="card card-body shadow-sm border-0 p-4 mt-4">
                        <ul class="nav nav-tabs" id="meetingTabs">
                            <li class="nav-item">
                                <button class="nav-link active text-primary" id="upcoming-tab"
                                    data-type="upcoming">Reuniones Próximas</button>
                            </li>
                            <li class="nav-item">
                                <button class="nav-link" id="past-tab" data-type="past">Reuniones Pasadas</button>
                            </li>
                        </ul>

                        <!-- Contenedor de contenido -->
                        <div id="meetingsContainer" class="mt-4"></div>
                    </div>
                </div>
            </div>
        </div>
        @include('include.footer')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const message = document.getElementById('message');
            const meetingsContainer = document.getElementById('meetingsContainer');

            function loadMeetings(type) {
                message.style.display = 'none';
                meetingsContainer.innerHTML = '<p>Cargando reuniones...</p>';

                fetch(`/docente/zoom/meetings/filter?type=${type}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.error) {
                            message.textContent = data.error;
                            message.className = 'alert alert-danger';
                            message.style.display = 'block';
                            meetingsContainer.innerHTML = '';
                        } else {
                            meetingsContainer.innerHTML = `
                                <div class="tab-content" id="myTabContent-2">
                                    <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel" aria-labelledby="home-tab-2">
                                        <div class="table-responsive">
                                            <table id="datatableGeneral" class="table table-hover table-bordered table-sm display rounded-3" style="min-width:100%; border-top-left-radius: 0.25rem; border-top-right-radius: 0.25rem;">
                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Tema</th>
                                                        <th class="text-center">Hora de inicio</th>
                                                        <th class="text-center">Duración (minutos)</th>
                                                        <th class="text-center">Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    ${data.map(meeting => `
                                                        <tr>
                                                            <td class="text-center text-primary">${meeting.topic}</td>
                                                            <td class="text-center">${new Date(meeting.start_time).toLocaleString()}</td>
                                                            <td class="text-center">${meeting.duration}</td>
                                                            <td class="text-center">
                                                                <div class="d-flex justify-content-center">
                                                                    <!-- Botón de eliminar -->
                                                                    <form action="/docente/zoom/meetings/${meeting.id}" method="POST" style="display:inline;" id="deleteForm-${meeting.id}">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="button" class="btn btn-danger btn-sm rounded-2 me-2" onclick="showDeleteModal(${meeting.id})">
                                                                            <i class="fa fa-trash"></i>
                                                                        </button>
                                                                    </form>
                                                                    <!-- Botón de unirse -->
                                                                    <a href="${meeting.join_url}" target="_blank" class="btn btn-success shadow btn-sm rounded-2 me-2" title="Unirse a la reunión">
                                                                        <i class="fa fa-play"></i>
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>

                                                        <!-- Modal de confirmación de eliminación -->
                                                        <div class="modal fade" id="deleteModal-${meeting.id}" tabindex="-1" aria-labelledby="deleteModalLabel-${meeting.id}" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="deleteModalLabel-${meeting.id}">Confirmar eliminación</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <p>¿Estás seguro de que deseas eliminar esta reunión de Zoom? Esta acción no se puede deshacer.</p>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                                        <button type="button" class="btn btn-danger" onclick="confirmDelete(${meeting.id})">Eliminar</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    `).join('')}
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }
                    })
                    .catch(error => {
                        message.textContent = 'Error al cargar las reuniones.';
                        message.className = 'alert alert-danger';
                        message.style.display = 'block';
                        meetingsContainer.innerHTML = '';
                    });
            }

            document.querySelectorAll('#meetingTabs .nav-link').forEach(tab => {
                tab.addEventListener('click', function() {
                    // Eliminar las clases 'active' y 'text-primary' de la pestaña activa
                    document.querySelector('#meetingTabs .nav-link.active').classList.remove('active');
                    document.querySelector('#meetingTabs .nav-link.text-primary').classList.remove('text-primary');

                    // Añadir las clases 'active' y 'text-primary' a la pestaña clicada
                    this.classList.add('active', 'text-primary');

                    // Llamar a la función para cargar las reuniones correspondientes
                    loadMeetings(this.dataset.type);
                });
            });

            // Carga inicial
            loadMeetings('upcoming');
        });

        document.addEventListener('DOMContentLoaded', function() {
            const startTimeInput = document.getElementById('start_time');
            const form = startTimeInput.closest('form');
            const message = document.getElementById('message');

            function getLimaTime() {
                const nowUTC = new Date(); // Hora actual en UTC
                const limaTimeOffset = new Date().getTimezoneOffset() / 60; // Diferencia en horas con UTC
                const limaHourOffset = limaTimeOffset + 5; // UTC - 5 para Lima
                return new Date(nowUTC.getTime() - limaHourOffset * 60 * 60 * 1000);
            }

            function validateDateTimeInput(event) {
                const now = getLimaTime(); // Hora actual en Lima
                const selectedDate = new Date(startTimeInput.value);

                // Validar si el campo está vacío o si la fecha seleccionada es inválida
                if (!startTimeInput.value) {
                    showMessage('Por favor, selecciona una fecha y hora.', 'danger');
                    event.preventDefault();
                    return false;
                }

                // Validar si la fecha seleccionada es en el pasado
                if (selectedDate < now) {
                    showMessage('No puedes seleccionar una fecha en el pasado.', 'danger');
                    event.preventDefault();
                    return false;
                }

                // Todo está correcto, borrar mensajes anteriores
                showMessage('', 'success');
                return true;
            }

            function showMessage(text, type) {
                message.textContent = text;
                message.className = `alert alert-${type}`;
                message.style.display = text ? 'block' : 'none';
            }

            // Validar al enviar el formulario
            form.addEventListener('submit', validateDateTimeInput);

            // Validar dinámicamente al cambiar el campo
            startTimeInput.addEventListener('input', function() {
                validateDateTimeInput(new Event('input'));
            });

            // Configurar restricciones iniciales en el campo de fecha
            const now = getLimaTime();
            startTimeInput.min = now.toISOString().slice(0, 16); // Solo validación de día
        });
    </script>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>
    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';

        // Mostrar el modal de confirmación de eliminación
        function showDeleteModal(meetingId) {
            var myModal = new bootstrap.Modal(document.getElementById('deleteModal-' + meetingId));
            myModal.show();
        }

        // Enviar el formulario de eliminación
        function confirmDelete(meetingId) {
            document.getElementById('deleteForm-' + meetingId).submit();
        }
    </script>
    @vite(['resources/js/login/logout.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
