<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestión de Semanas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        @media (max-width: 419px) {
            .zoom-card {
                margin-left: 0 !important;
                min-width: 100% !important;
            }
        }

        .disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        #zoom-loader-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            z-index: 9999;
        }

        #zoom-loader {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
    </style>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')

        @section('titlenavbar')
            {{ __('Gestión de Semanas') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- card -->
                            <div class="col-xl-6 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodos Lectivos</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-6 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">cursos</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsubject">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card" id="accordion-three">
                                        <div class="card-header flex-wrap px-3">
                                            <div>
                                                <h4 class="card-title">Clases del curso</h4>
                                            </div>
                                            <div class="col-xl-3">
                                                <select id="txt_semestre" name="txt_semestre"
                                                    class="default-select  form-control form-control-sm form-control-primary">
                                                    <option value="" selected disabled>Periodo</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                        <div class="tab-content" id="myTabContent-2">
                                            <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                                aria-labelledby="home-tab-2">
                                                <div class="card-body p-2">
                                                    <div class="table-responsive">
                                                        <table id="datatableGeneral"
                                                            class="table table-hover table-bordered table-sm display table"
                                                            style="min-width:100%">
                                                            <thead class="thead-primary">
                                                                <tr>
                                                                    <th class="text-center">Clase / Semana</th>
                                                                    <th class="text-center">Día</th>
                                                                    <th class="text-center">Horario</th>
                                                                    <th class="text-center">Reunión Zoom</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody class="text-primary">
                                                                <!--  -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                    </div>
                                </div>
                                <!-- Column ends -->
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="createMeetingModal" tabindex="-1" aria-labelledby="createMeetingModalLabel"
                    inert="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="createMeetingModalLabel">Crear Reunión</h5>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="meetingTopic" class="form-label">Tema</label>
                                    <input type="text" id="meetingTopic" class="form-control"
                                        placeholder="Ingrese el tema de la reunión" required>
                                </div>

                                <div class="mb-3">
                                    <label for="meetingStartTime" class="form-label">Fecha y Hora de Inicio</label>
                                    <input type="datetime-local" id="meetingStartTime" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label for="meetingDuration" class="form-label">Duración (minutos)</label>
                                    <input type="number" id="meetingDuration" class="form-control"
                                        placeholder="Duración en minutos" required>
                                </div>

                                <div class="mb-3">
                                    <label for="meetingAgenda" class="form-label">Agenda</label>
                                    <textarea id="meetingAgenda" class="form-control" rows="4" placeholder="Escriba la agenda de la reunión"></textarea>
                                </div>

                                <input id="meetingIdclass" type="hidden" name="meetingIdclass">
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                                    id="closeModalCreateZoomButton">Cerrar</button>
                                <button type="button" class="btn btn-primary" onclick="createZoomMeeting()"
                                    id="confirmModalCreateZoomButton">Guardar Reunión</button>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="modal fade" id="deleteConfirmationModal" tabindex="-1">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar Eliminación</h5>
                            </div>
                            <div class="modal-body">
                                ¿Estás seguro de que deseas eliminar esta reunión?
                            </div>
                            <div class="modal-footer">
                                <button class="btn btn-secondary" data-dismiss="modal" id="closeModalButton"
                                    onclick="hideModalDeleteMetting()">Cerrar</button>
                                <button id="confirmDeleteButton" class="btn btn-danger">Eliminar</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="zoom-loader-container" style="display: none;">
                    <div id="zoom-loader" class="d-flex justify-content-center align-items-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                </div>

                <div id="toastContainer" class="position-fixed bottom-0 end-0 p-3" style="z-index: 999999;"></div>
            </div>

            <!--**********************************
            Content body end
        ***********************************-->
            @include('include.footer')

        </div>

        <form id="formModal" novalidate>
            @csrf
            <input id="txt-idsubjectclass" name="txt-idsubjectclass" type="hidden">
            <input id="txt-idsubjectenrollment" name="txt-idsubjectenrollment" type="hidden">
            <input id="txt-estado_asistencia" name="txt-estado_asistencia" type="hidden">
        </form>

        <!--**********************************
        Main wrapper end
    ***********************************-->


        <!--**********************************
        Scripts
    ***********************************-->

        @include('include.plugins-scripts')

        @include('include.datatable-scripts')

        <!-- Template JS -->
        <script src="{{ asset('/js/custom.min.js') }}"></script>
        <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

        <!-- Logout JS -->
        <script>
            var logoutRoute = '{{ route('logout') }}';
            /*--------------------------------------------------------*/
            /*------------------ CREAR ZOOM MEETING ------------------*/
            /*--------------------------------------------------------*/
            // Función para autocompletar los campos del modal al crear una reunión
            function preFillCreateMeetingModal(fecha, horaini, duracion, account_id, client_id, client_secret, id, apellido_pa,
                apellido_ma, nombres, clase, dia, nombre_curso, idclass) {
                // Mostrar la modal
                $('#createMeetingModal').modal('show');

                // Asignar el idclass al input
                $('#meetingIdclass').val(idclass);

                // Formatear tema automáticamente
                $('#meetingTopic').val(`${nombre_curso} - ${clase}`);

                // Formatear fecha y hora para el input datetime-local
                const fechaHoraFormateada = `${fecha}T${horaini}`;
                $('#meetingStartTime').val(fechaHoraFormateada);

                // Separamos las horas, minutos y segundos
                var partes = duracion.split(":");
                var horas = parseInt(partes[0]);
                var minutos = parseInt(partes[1]);
                var segundos = parseInt(partes[2]);

                // Convertimos todo a minutos
                var totalMinutos = (horas * 60) + minutos + (segundos / 60);

                // Asignamos el valor a #meetingDuration
                $('#meetingDuration').val(Math.round(totalMinutos));

                // Formatear agenda
                var docente_nombre_completo = nombres + ' ' + apellido_pa + ' ' + apellido_ma;
                const agendaTexto =
                    `📅 Fecha: ${fecha}\n🕰️ Hora: ${horaini}\n⏳ Duración: ${duracion} \n📚 Unidad Didáctica: ${nombre_curso}\n👨‍🏫 Docente: ${docente_nombre_completo}`;
                $('#meetingAgenda').val(agendaTexto);
            }

            function setupDateTimeValidator() {
                // Deshabilitar fechas pasadas en el campo datetime-local
                const now = new Date();
                const nowFormatted = now.toISOString().slice(0, 16); // YYYY-MM-DDTHH:MM
                $('#meetingStartTime').attr('min', nowFormatted);
            }

            function createZoomMeeting() {
                const meetingStartTime = $('#meetingStartTime').val();
                const meetingStartTimeObj = new Date(meetingStartTime);

                const now = new Date();
                if (meetingStartTimeObj < now) {
                    showToast('No se puede agendar reuniones en el pasado.', 'danger');
                    return;
                }

                const meetingData = {
                    topic: $('#meetingTopic').val(),
                    duration: $('#meetingDuration').val(),
                    agenda: $('#meetingAgenda').val(),
                    idclass: $('#meetingIdclass').val(),
                    start_time: meetingStartTime,
                };

                $('#confirmModalCreateZoomButton').prop('disabled', true);
                $('#zoom-loader-container').show();

                // Envío de la solicitud AJAX
                $.ajax({
                    url: '/docente/zoom/meeting/class',
                    type: 'POST',
                    data: meetingData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            showToast('Reunión creada exitosamente.', 'success');
                            $('#createMeetingModal').modal('hide');
                            window.createSuccess = true; // Activar la actualización de la lista
                        } else {
                            showToast('Error: ' + response.error, 'danger');
                        }
                    },
                    error: function() {
                        showToast('Hubo un error al crear la reunión.', 'danger');
                    },
                    complete: function() {
                        $('#confirmModalCreateZoomButton').prop('disabled', false);
                        $('#zoom-loader-container').hide();
                    }
                });
            }

            // Llamar a esta función para habilitar la validación de fecha al cargar la página
            setupDateTimeValidator();

            function hideModalCreateZoomMeeting() {
                // Remover el foco del botón dentro del modal
                $('#createMeetingModal').find(':focus').blur();

                // Habilitar el botón de confirmación
                $('#confirmModalCreateZoomButton').prop('disabled', false);

                // Ocultar la modal
                $('#createMeetingModal').modal('hide');

                // Remover el atributo inert para permitir la interacción con la modal
                $('#createMeetingModal').attr('inert', 'true');
            }

            $('#createMeetingModal').on('hidden.bs.modal', function() {
                // Cuando la modal esté oculta, agrega inert para deshabilitar la interacción
                $('#createMeetingModal').attr('inert', 'true');
            });

            $('#createMeetingModal').on('shown.bs.modal', function() {
                // Cuando la modal esté visible, remueve inert para permitir la interacción
                $('#createMeetingModal').removeAttr('inert');
            });

            /*--------------------------------------------------------*/
            /*---------------- ELIMINAR ZOOM MEETING -----------------*/
            /*--------------------------------------------------------*/
            function confirmDeleteZoomMeeting(meetingId, idClass) {
                // Mostrar la modal
                $('#deleteConfirmationModal').modal('show');

                // Habilitar botones
                $('#confirmDeleteButton').prop('disabled', false);
                $('#closeModalButton').prop('disabled', false);

                // Añadir evento de click al botón de confirmación
                $('#confirmDeleteButton').off('click').on('click', function() {
                    // Deshabilitar botones durante la acción
                    $('#confirmDeleteButton').prop('disabled', true);
                    $('#closeModalButton').prop('disabled', true);
                    $('#zoom-loader-container').show();

                    // Realizar la petición de eliminación
                    $.ajax({
                        type: "DELETE",
                        url: `/docente/zoom/meetings/delete/${meetingId}`,
                        data: {
                            idClass: idClass,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            showToast('Reunión eliminada correctamente.', 'success');
                            $('#deleteConfirmationModal').modal('hide');

                            // Establecer el estado global que la eliminación fue exitosa
                            window.deleteSuccess = true;
                            $('#zoom-loader-container').hide();
                        },
                        error: function(error) {
                            showToast('Error al eliminar la reunión.', 'danger');
                            // Habilitar nuevamente los botones
                            $('#confirmDeleteButton').prop('disabled', false);
                            $('#closeModalButton').prop('disabled', false);

                            // Establecer el estado global a false en caso de error
                            window.deleteSuccess = false;
                            $('#zoom-loader-container').hide();
                        }
                    });
                });

                // Cuando la modal se oculte, agregar inert solo a la modal, no al botón de cerrar
                $('#deleteConfirmationModal').on('hidden.bs.modal', function() {
                    // Añadir inert a la modal
                    $('#deleteConfirmationModal').attr('inert', 'true');
                });

                // Cuando la modal se muestre, quitar inert
                $('#deleteConfirmationModal').on('shown.bs.modal', function() {
                    // Eliminar inert para permitir la interacción
                    $('#deleteConfirmationModal').removeAttr('inert');
                });

                // Asegurarse de que el botón de cerrar esté habilitado incluso si la modal se oculta
                $('#closeModalButton').on('click', function() {
                    $('#deleteConfirmationModal').modal('hide');
                });
            }

            function hideModalDeleteMetting() {
                // Habilitar el botón de confirmación
                $('#confirmDeleteButton').prop('disabled', false);

                // Ocultar la modal
                $('#deleteConfirmationModal').modal('hide');

                // Remover el atributo inert para permitir la interacción con la modal
                $('#deleteConfirmationModal').attr('inert', 'true');
            }

            $('#deleteConfirmationModal').on('hidden.bs.modal', function() {
                // Cuando la modal esté oculta, agrega inert para deshabilitar la interacción
                $('#deleteConfirmationModal').attr('inert', 'true');
            });

            $('#deleteConfirmationModal').on('shown.bs.modal', function() {
                // Cuando la modal esté visible, remueve inert para permitir la interacción
                $('#deleteConfirmationModal').removeAttr('inert');
            });

            /*--------------------------------------------------------*/
            /*-------------------- MANEJO DE TOAST -------------------*/
            /*--------------------------------------------------------*/
            function showToast(message, type) {
                let toastHtml = `
            <div class="toast align-items-center text-white bg-${type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>`;

                // Asegúrate de agregar el HTML al contenedor de los toasts
                $('#toastContainer').html(toastHtml);

                // Inicializa el toast con el delay de 5000 ms (5 segundos)
                var toastElement = $('.toast');
                toastElement.toast({
                    delay: 5000
                });

                // Muestra el toast
                toastElement.toast('show');

                // Agrega un evento para que se cierre cuando termine el delay
                toastElement.on('hidden.bs.toast', function() {
                    $(this).remove(); // Elimina el toast del DOM después de cerrarse
                });
            }

            $(document).ready(function() {
                $('#deleteConfirmationModal').on('hidden.bs.modal', function() {
                    $('#confirmDeleteButton').prop('disabled', false);
                });
            });

            /*--------------------------------------------------------*/
            /*--------- UNIRSE A UNA REUNIÓN DE ZOOM METTING ---------*/
            /*--------------------------------------------------------*/
            function joinZoomMeeting(idZoomMeeting) {
                // Mostrar el loader con fondo y desenfoque
                $('#zoom-loader-container').show();

                $.ajax({
                    url: '/docente/zoom/meetings/' + idZoomMeeting, // Ruta que corresponde al controlador
                    type: 'GET',
                    success: function(response) {
                        // Ocultar el loader cuando la respuesta llega
                        $('#zoom-loader-container').hide();

                        if (response.join_url) {
                            // Si el link de la reunión es obtenido, lo abrimos en una nueva pestaña
                            window.open(response.join_url, '_blank');
                        } else {
                            alert('No se pudo obtener el link de la reunión.');
                        }
                    },
                    error: function() {
                        // Ocultar el loader en caso de error
                        $('#zoom-loader-container').hide();
                        alert('Ocurrió un error al intentar obtener el link de la reunión.');
                    }
                });
            }
        </script>
        @vite(['resources/js/login/logout.js']);

        <!--  Page JS -->
        @vite(['resources/js/docente/semanas.js']);
        @vite(['resources/js/common/timeline/semesters.js']);

        {{-- rowgroup --}}
        <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
