
<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Perfil de Docente</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Editar Perfil
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
					<div class="col-xl-4 col-lg-4">
						<div class="clearfix">
							<div class="card card-bx profile-card author-profile m-b30">
								<div class="card-body">
									<div class="p-5">
										<div class="author-profile">
											<div class="author-media">
                                                @if (Auth::User()->genre_id == 1)
                                                    <img class="img_user" src="{{ asset('/images/avatar/male.jpg') }}"  class="ms-0" alt="">
                                                @elseif (Auth::User()->genre_id == 2)
                                                    <img class="img_user" src="{{ asset('/images/avatar/female.jpg') }}"  class="ms-0" alt="">
                                                @else
                                                    <img class="img_user" src="{{ asset('/images/avatar/other.jpg') }}"  class="ms-0" alt="">
                                                @endif
											</div>
											<div class="author-info">
												<h6 id="data-apnom" class="title"></h6>
												<span>Docente</span>
											</div>
										</div>
									</div>
									<div class="info-list">
										<ul>
                                            <li>TIPO DE CONTRATO:<span id="data-tipocontrato"></span></li>
                                            <li>ESTADO:<span id="data-estado"></span></li>
                                            <li>TIPO DE DOCENTE:<span id="data-teachertype"></span></li>
                                            <li>DESCRIPCION DEL TIPO:<span id="data-descripcion"></span></li>
										</ul>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-8 col-lg-8">
						<div class="card profile-card card-bx">
							<div class="card-header">
								<h6 class="title">Datos de la cuenta de usuario</h6>
							</div>
							<form class="profile-form">
								<div class="card-body">
									<div class="row">
                                        <input id="txt_idgenero" name="txt_idgenero" type="hidden">
                                        <input id="txt_iddepartamento" name="txt_idgenero" type="hidden">
										<div class="col-sm-4 m-b30">
											<label class="form-label">Tipo de documento</label>
											<input id="data-tipoidenti" type="text" class="form-control" readonly>
										</div>
										<div class="col-sm-4 m-b30">
											<label class="form-label">Numero de documento</label>
											<input id="data-nroidenti" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Fecha de nacimiento</label>
											<input id="data-fecnac" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Genero</label>
											<input id="data-genero" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Correo</label>
											<input id="data-correo" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Telefono</label>
											<input id="data-telefono" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Celular</label>
											<input id="data-celular" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Direccion</label>
											<input id="data-direccion" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Departamento</label>
											<input id="data-departamento" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Provincia</label>
											<input id="data-provincia" type="text" class="form-control" readonly>
										</div>
                                        <div class="col-sm-4 m-b30">
											<label class="form-label">Distrito</label>
											<input id="data-distrito" type="text" class="form-control" readonly>
										</div>
									</div>
								</div>
								<div class="card-footer">
									<input id="editBtn" class="btn btn-primary" type="button" value="EDITAR DATOS">
                                    <input id="passwordBtn" class="btn btn-primary pl-4" type="button" value="CAMBIAR CONTRASEÑA">
								</div>
							</form>
						</div>
					</div>
				</div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">EDITAR DATOS DE PERFIL</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser" name="txt_iduser" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_identificacion" class="form-label text-primary">Identificacion</label>
                                    <input id="txt_identificacion" name="txt_identificacion" type="text"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" readonly style="background-color: #dadada">
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_user" class="form-label text-primary">Nombres y Apellidos</label>
                                    <input id="txt_user" name="txt_user" type="text"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" readonly style="background-color: #dadada">
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_fecnac" class="form-label text-primary">Fecha de Nacimiento</label>
                                    <input id="txt_fecnac" name="txt_fecnac" type="date"
                                        class="form-control form-control-sm" placeholder="" readonly>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_correo" class="form-label text-primary">Correo Electrónico</label>
                                    <input id="txt_correo" name="txt_correo" type="text"
                                        class="form-control form-control-sm" placeholder="example@email.com" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>

                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_telefono" class="form-label text-primary">Teléfono</label>
                                    <input id="txt_telefono" name="txt_telefono" type="text"
                                        class="form-control form-control-sm" placeholder="357-2984">
                                    {{-- @include('include.div.invalid-feedback')  --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_celular" class="form-label text-primary">Celular</label>
                                    <input id="txt_celular" name="txt_celular" type="text"
                                        class="form-control form-control-sm" placeholder="967-542-321" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_genero" class="form-label text-primary">Género</label>
                                    <select id="txt_genero" name="txt_genero"
                                        class="default-select form-control form-control-sm" readonly style="background-color: #dadada">
                                        <!-- combobox -->
                                        @include('include.combobox.genre')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_departamento" class="form-label text-primary">Departamento</label>
                                    <select id="txt_departamento" name="txt_departamento"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        @include('include.combobox.departamento')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_provincia" class="form-label text-primary">Provincia</label>
                                    <select id="txt_provincia" name="txt_provincia"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->

                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_distrito" class="form-label text-primary">Distrito</label>
                                    <select id="txt_distrito" name="txt_distrito"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->

                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt_direccion" name="txt_direccion" type="text"
                                        class="form-control form-control-sm"
                                        placeholder="Ejemplo: URB. SANTO DOMINGO ETAPA X MZ. M LT. 2" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal2" novalidate>
        @csrf
        <div id="modalUpdatePassword" class="modal fade" tabindex="-1" aria-labelledby="modalUpdatePasswordLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_identificacion2" class="form-label text-primary">Identificacion</label>
                                    <input id="txt_identificacion2" name="txt_identificacion2" type="text"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_user2" class="form-label text-primary">Nombres y Apellidos</label>
                                    <input id="txt_user2" name="txt_user2" type="text"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" readonly>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password1" class="form-label text-primary">Contraseña Actual</label>
                                    <input id="txt_password1" name="txt_password1" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password2" class="form-label text-primary">Contraseña Nueva</label>
                                    <input id="txt_password2" name="txt_password2" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePassword" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/docente/editar_perfil.js']);
    @vite(['resources/js/common/combobox/roles.js']);
    @vite(['resources/js/common/combobox/ubigeo.js']);

</body>
</html>
