<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Ofertas Laborales</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Ofertas Laborales
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Información sobre ofertas laborales</h4>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Empresa</th>
                                                                <th class="text-center">Categoría</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Vacantes</th>
                                                                <th class="text-center">Fecha inicio - fin</th>
                                                                <th class="text-center">Rango Salarial</th>
                                                                <th class="text-center">Ver Detalles</th>
                                                                {{-- <th class="text-center">Estado</th> --}}
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
    </form>

    <!-- Modal Para ver el detalle-->
    <div id="modalDetail" class="modal fade" tabindex="-1" aria-labelledby="modalDetailLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-center modal-lg">
            <div class="modal-content">
                <div class="modal-header text-light" style="background-color: #292929">
                    <h1 class="modal-title fs-5 text-light" id="modalDetailLabel">Detalle de la Oferta Laboral</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="background-color: #e7e7e7">
                    <div class="row">
                        <div class="row col-xl-12">
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_1" class="form-label text-dark">Empresa</label>
                                <input id="txt_1" name="txt_1" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_2" class="form-label text-dark">Categoria</label>
                                <input id="txt_2" name="txt_2" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_3" class="form-label text-dark">Puesto</label>
                                <input id="txt_3" name="txt_3" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_4" class="form-label text-dark">Vacantes</label>
                                <input id="txt_4" name="txt_4" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_5" class="form-label text-dark">Tipo</label>
                                <input id="txt_5" name="txt_5" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_6" class="form-label text-dark">Modalidad</label>
                                <input id="txt_6" name="txt_6" type="text" class="form-control form-control-sm"
                                    readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_7" class="form-label text-dark">Experiencia</label>
                                <input id="txt_7" name="txt_7" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_8" class="form-label text-dark">Nivel educativo</label>
                                <input id="txt_8" name="txt_8" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_9" class="form-label text-dark">Fecha de Publicación</label>
                                <input id="txt_9" name="txt_9" type="date"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_10" class="form-label text-dark">Fecha de Cierre</label>
                                <input id="txt_10" name="txt_10" type="date"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_11" class="form-label text-dark">Salario Minímo</label>
                                <input id="txt_11" name="txt_11" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_12" class="form-label text-dark">Salario Máximo</label>
                                <input id="txt_12" name="txt_12" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_13" class="form-label text-dark">Estado</label>
                                <input id="txt_13" name="txt_13" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_14" class="form-label text-dark">Departamento</label>
                                <input id="txt_14" name="txt_14" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_15" class="form-label text-dark">Provincia</label>
                                <input id="txt_15" name="txt_15" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_16" class="form-label text-dark">Distrito</label>
                                <input id="txt_16" name="txt_16" type="text"
                                    class="form-control form-control-sm" readonly>
                            </div>
                            <!-- data -->
                            <div class="col-xl-12    col-md-6 col-sm-12 col-12 mb-3">
                                <label for="txt_17" class="form-label text-dark">Descripción</label>
                                <textarea id="txt_17" name="txt_17" class="form-control overflow-auto" rows="7" readonly></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="background-color: #292929">
                    <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                        data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <script>
        tinymce.init({
            selector: '#txt_17',
            readonly: true,
        });
    </script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/docente/ofertas_laborales.js']);
</body>

</html>
