<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Notas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')

        @section('titlenavbar')
            {{ __('Gestionar Notas del Estudiante') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!--  -->
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralCursos"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Programa</th>
                                                                <th class="text-center">Plan</th>
                                                                <th class="text-center">Periodo</th>
                                                                <th class="text-center">Código</th>
                                                                <th class="text-center">Nombre curso</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Creditos-Horas</th>
                                                                <th class="text-center">Condicion</th>
                                                                <th class="text-center">Seccion</th>
                                                                <th class="text-center">Turno</th>
                                                                <th class="text-center">Ver Instrumentos</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-3 col-lg-12 col-md-12 col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title" id="text_titulo_card"><i class="fas fa-cog fa-spin"></i>
                                            Datos de la curso seleccionada</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="basic-form">
                                            <div class="form-validation">
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">Programa</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-programa">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">Plan</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-plan">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">Periodo</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-periodo">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">curso</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-curso">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mt-3">
                                                    <label id="name_archivo_upload"
                                                        class="form-label mb-2 fs-13 label-color"></label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--  -->
                            <div class="col-xl-9">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralIndicadores"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Indicador</th>
                                                                <th class="text-center">Actividad</th>
                                                                <th class="text-center">Nota</th>
                                                                <th class="text-center">Ver Alumnos</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>



            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-3 col-lg-12 col-md-12 col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title" id="text_titulo_card"><i
                                                class="fas fa-cog fa-spin"></i> Datos de la nota seleccionado</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="basic-form">
                                            <div class="form-validation">
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label
                                                        class="col-sm-3 col-form-label text-primary">Indicador</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-indicador">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label
                                                        class="col-sm-3 col-form-label text-primary">Actividad</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-actividad">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">Tipo de
                                                        Nota</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-tipo_nota">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                                    <label class="col-sm-3 col-form-label text-primary">Nombre de
                                                        Nota</label>
                                                    <input type="text" class="form-control form-control-sm"
                                                        id="data-nota">
                                                </div>
                                                <div class="col-xl-12 col-lg-6 col-md-6 col-12 mt-3">
                                                    <label id="name_archivo_upload"
                                                        class="form-label mb-2 fs-13 label-color"></label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--  -->
                            <div class="col-xl-9">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralEstudiantes"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                {{-- <th class="text-center">N</th> --}}
                                                                <th class="text-center">Identificacion</th>
                                                                <th class="text-center">Apellidos y nombres</th>
                                                                <th class="text-center">Nota</th>
                                                                <th class="text-center">Editar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>

    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Editar nota</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idstudentgrade" name="txt-idstudentgrade" type="hidden">
                                <!-- data -->
                                <input id="txt-idgrade" name="txt-idgrade" type="hidden">
                                <!-- data -->
                                <input id="txt-idsubjectenrollment" name="txt-idsubjectenrollment" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-curso" class="form-label text-primary">Ud. Didáctica</label>
                                    <input id="txt-curso" name="txt-curso" type="text"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estudiante" class="form-label text-primary">Estudiante</label>
                                    <input id="txt-estudiante" name="txt-estudiante" type="text"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombre_nota" class="form-label text-primary">Nombre Nota</label>
                                    <input id="txt-nombre_nota" name="txt-nombre_nota" type="text"
                                        class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nota_estudiante" class="form-label text-primary">Nota</label>
                                    <input id="txt-nota_estudiante" name="txt-nota_estudiante" type="num"
                                        class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button"
                            class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/docente/Nota.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
