<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Recursos y Materiales</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Gestionar Recuros y Materiales
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <form class="needs-validation" id="formModal">
            @csrf
            <div class="content-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="row">

                                <div class="col-xl-3">
                                    <div class="col-12">
                                        <div class="card">
                                            <div
                                                class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                                <h2 class="card-title text-light">Periodos Lectivos</h2>
                                            </div>
                                            <div class="card-body p-0">
                                                <div id="DZ_W_TimeLine"
                                                    class="widget-timeline dlab-scroll height200 my-2 px-2">
                                                    <ul id="listar_semestres" class="timeline">
                                                        {{-- El contenido se genera por JS --}}
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="card">
                                            <div
                                                class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                                <h2 class="card-title text-light">Cursos</h2>
                                            </div>
                                            <div class="card-body p-0">
                                                <div id="DZ_W_TimeLine"
                                                    class="widget-timeline dlab-scroll height200 my-2 px-2">
                                                    <ul id="listar_asignaturas" class="timeline">
                                                        {{-- El contenido se genera por JS --}}
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-9">
                                    <div class="card" id="accordion-three">
                                        <div class="col-xl-12 col-xxl-12 col-lg-12 col-md-12">
                                            <div class="row gx-0">
                                                <div class="col-xl-12">
                                                    <div class="file-header">
                                                        <div class="card-body py-0">
                                                            <div class="page-titles">
                                                                <div class="my-2">
                                                                    <div id="div_asignatura" class="heading">
                                                                        <h3>Seleccione un curso</h3>
                                                                    </div>
                                                                    <div class="file-path">
                                                                        <div class="me-2">
                                                                            <svg width="20" height="16"
                                                                                viewBox="0 0 20 16" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M18.9833 6.64169C18.9049 6.545 18.8058 6.46712 18.6933 6.41376C18.5808 6.36041 18.4578 6.33293 18.3333 6.33335H16.6666V5.50002C16.6666 4.83698 16.4033 4.20109 15.9344 3.73225C15.4656 3.26341 14.8297 3.00002 14.1666 3.00002H8.93331L8.66665 2.16669C8.49377 1.67771 8.1731 1.2546 7.74906 0.955986C7.32502 0.657367 6.81861 0.498019 6.29998 0.500019H3.33331C2.67027 0.500019 2.03439 0.763411 1.56555 1.23225C1.09671 1.70109 0.833313 2.33698 0.833313 3.00002V13C0.833313 13.6631 1.09671 14.2989 1.56555 14.7678C2.03439 15.2366 2.67027 15.5 3.33331 15.5H15.3333C15.901 15.4984 16.4512 15.3036 16.8935 14.9476C17.3357 14.5917 17.6437 14.0959 17.7666 13.5417L19.1666 7.35002C19.192 7.22578 19.1886 7.0974 19.1569 6.97466C19.1251 6.85191 19.0657 6.73803 18.9833 6.64169ZM4.47498 13.1834C4.43264 13.3713 4.32647 13.5388 4.17453 13.6574C4.02259 13.7759 3.83428 13.8381 3.64165 13.8334H3.33331C3.1123 13.8334 2.90034 13.7456 2.74406 13.5893C2.58778 13.433 2.49998 13.221 2.49998 13V3.00002C2.49998 2.779 2.58778 2.56704 2.74406 2.41076C2.90034 2.25448 3.1123 2.16669 3.33331 2.16669H6.29998C6.4817 2.1572 6.66153 2.20746 6.81201 2.30978C6.96248 2.4121 7.07533 2.56087 7.13331 2.73335L7.58331 4.10002C7.63679 4.25897 7.73698 4.39809 7.87079 4.49919C8.0046 4.60029 8.1658 4.65867 8.33331 4.66669H14.1666C14.3877 4.66669 14.5996 4.75448 14.7559 4.91076C14.9122 5.06704 15 5.27901 15 5.50002V6.33335H6.66665C6.47401 6.32864 6.2857 6.39084 6.13376 6.50935C5.98182 6.62786 5.87565 6.79537 5.83331 6.98335L4.47498 13.1834ZM16.1416 13.1834C16.0993 13.3713 15.9931 13.5388 15.8412 13.6574C15.6893 13.7759 15.5009 13.8381 15.3083 13.8334H6.00831C6.05135 13.7405 6.08216 13.6425 6.09998 13.5417L7.33331 8.00002H17.3333L16.1416 13.1834Z"
                                                                                    fill="#01A3FF"></path>
                                                                            </svg>
                                                                        </div>
                                                                        <div id="folder_bar">
                                                                            <h4><a href="javascript:void(0);"
                                                                                    id="allfolders"></a>
                                                                                <a href="javascript:void(0);"
                                                                                    id="selectFolder"></a>
                                                                                <a href="javascript:void(0);"
                                                                                    id="selectSubfolder"></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex my-2">
                                                                    <button id="viewSyllabusBtn" style="display:none;"
                                                                        class="btn btn-dark btn-sm me-2" type="button">
                                                                        <i class="fa-solid fa-eye"></i> Ver Sílabo
                                                                    </button>
                                                                    <button id="uploadSyllabusBtn" style="display:none;"
                                                                        class="btn btn-info btn-sm me-2" type="button">
                                                                        <i class="fa-solid fa-file-arrow-up"></i> Cargar
                                                                        Sílabo
                                                                    </button>
                                                                    <button id="createFolderBtn" style="display:none;"
                                                                        class="btn btn-primary btn-sm" type="button">
                                                                        + Agregar Carpeta
                                                                    </button>
                                                                    <button id="createSubfolderBtn"
                                                                        style="display:none;"
                                                                        class="btn btn-primary btn-sm" type="button">
                                                                        + Agregar Subcarpeta
                                                                    </button>
                                                                    <button id="createFolderfileBtn"
                                                                        style="display:none;"
                                                                        class="btn btn-primary btn-sm" type="button">
                                                                        + Agregar Archivo
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-12">
                                                    <ul class="folder-structure dlab-scroll" id="list_folders">
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <form id="folderFormModal" name="folderFormModal" class="needs-validation" novalidate>
        @csrf
        <div id="folderModalCreateUpdate" class="modal fade bd-example-modal-lg show" tabindex="-1" aria-modal="true"
            role="dialog">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 id="folderModalCreateUpdateLabel" class="modal-title fs-5">Crear nueva carpeta</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-12 mb-3">
                                <!--data-->
                                <input type="hidden" id="dt_folder-subject_id" name="dt_folder-subject_id" value="0">
                                <!--data-->
                                <input type="hidden" id="dt_folder-id" name="dt_folder-id" value="0">
                                <div class="col-xl-12 mb-3">
                                    <label for="dt_folder-nombre" class="form-label text-primary">Nombre de la
                                        carpeta</label>
                                    <!--data-->
                                    <input type="text" class="form-control form-control-sm" id="dt_folder-nombre"
                                        name="dt_folder-nombre" placeholder="Examenes parciales" required>
                                    <div class="invalid-feedback">Ingrese un nombre de carpeta.</div>
                                </div>
                                <div class="col-xl-12 mb-3">
                                    <label for="dt_folder-descripcion" class="form-label text-primary">Descripcion
                                        (opcional)</label>
                                    <textarea class="form-control" id="dt_folder-descripcion"
                                        name="dt_folder-descripcion" rows="5"
                                        placeholder="Detalle una breve descripción">
                                        </textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light btn-sm"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button type="button" class="btn btn-primary btn-sm"
                            id="btnCreateUpdateFolder">Registrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <form id="subfolderFormModal" name="subfolderFormModal" class="needs-validation" novalidate>
        @csrf
        <div id="subfolderModalCreateUpdate" class="modal fade bd-example-modal-lg show" tabindex="-1" aria-modal="true"
            role="dialog">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 id="subfolderModalCreateUpdateLabel" class="modal-title fs-5">Crear nueva subcarpeta</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-12 mb-3">
                                <!--data-->
                                <input type="hidden" id="dt_subfolder-folder_id" name="dt_subfolder-folder_id"
                                    value="0">
                                <!--data-->
                                <input type="hidden" id="dt_subfolder-id" name="dt_subfolder-id" value="0">
                                <div class="col-xl-12 mb-3">
                                    <!--data-->
                                    <label for="dt_subfolder-nombre" class="form-label text-primary">Nombre de la
                                        subcarpeta</label>
                                    <input type="text" class="form-control form-control-sm" id="dt_subfolder-nombre"
                                        name="dt_subfolder-nombre" placeholder="Nombre de la subcarpeta" required>
                                    <div class="invalid-feedback">Ingrese un nombre de subcarpeta.</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light btn-sm"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button type="button" class="btn btn-primary btn-sm"
                            id="btnCreateUpdateSubfolder">Registrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <form id="folderfileFormModal" name="folderfileFormModal" class="needs-validation" novalidate>
        @csrf
        <div id="folderfileModalCreateUpdate" class="modal fade bd-example-modal-lg show" tabindex="-1"
            aria-modal="true" role="dialog">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 id="folderfileModalCreateUpdateLabel" class="modal-title fs-5">Subir archivo</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-12 mb-3">
                                <!--data-->
                                <input type="hidden" id="dt_folderfile-subject_id" name="dt_folderfile-subject_id"
                                    value="0">
                                <!--data-->
                                <input type="hidden" id="dt_folderfile-folder_id" name="dt_folderfile-folder_id"
                                    value="0">
                                <!--data-->
                                <input type="hidden" id="dt_folderfile-subfolder_id" name="dt_folderfile-subfolder_id"
                                    value="0">
                                <!--data-->
                                <input type="hidden" id="dt_folderfile-id" name="dt_folderfile-id" value="0">
                                <div class="col-xl-12 mb-3">
                                    <!--data-->
                                    <label for="dt_folderfile-archivo" class="form-label text-primary">Seleccione un
                                        archivo</label>
                                    <input id="dt_folderfile-archivo" name="dt_folderfile-archivo" type="file"
                                        class="form-control form-control-sm" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light btn-sm"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button type="button" class="btn btn-primary btn-sm"
                            id="btnCreateUpdateFolderfile">Registrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form id="syllabusFormModal" name="syllabusFormModal" class="needs-validation" novalidate
        enctype="multipart/form-data">
        @csrf
        <div id="syllabusModalCreateUpdate" class="modal fade" tabindex="-1" aria-modal="true" role="dialog">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 id="syllabusModalCreateUpdateLabel" class="modal-title fs-5">Cargar/Actualizar Sílabo</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-12 mb-3">
                                <input type="hidden" id="dt_syllabus-subject_id" name="dt_syllabus-subject_id"
                                    value="0">

                                <div class="col-xl-12 mb-3">
                                    <label for="dt_syllabus-archivo" class="form-label text-primary">Seleccione el
                                        archivo del Sílabo</label>
                                    <input id="dt_syllabus-archivo" name="dt_syllabus-archivo" type="file"
                                        class="form-control form-control-sm" required>
                                    <small class="form-text text-muted">Archivos permitidos: PDF, DOCX, PPTX (máx.
                                        5MB).</small>
                                    <div class="invalid-feedback">Debe seleccionar un archivo.</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light btn-sm"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button type="button" class="btn btn-primary btn-sm" id="btnUploadSyllabus">Cargar
                            Sílabo</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
            Content body end
        ***********************************-->
    @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/docente/repositorio.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>