<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Foros</title>

    <!-- FAVICONS ICON -->

    <link rel="stylesheet" href="{{ asset('/vendor/fullcalendar-5.11.0/lib/main.css') }}">

    <!-- Style css -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>

    <!--*******************
        Preloader start
    ********************-->
    @include('include.preloader')
    <!--*******************
        Preloader end
    ********************-->

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <!--**********************************
            Nav header start
        ***********************************-->
        @include('include.nav_header')
        @extends('include.header')
        @section('titlenavbar')
            Foros
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid pt-0">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <!-- Row -->
                        <div class="row">
                            <!--column-->
                            <div class="col-xl-4">
                                <div class="card" style="height: 25%">
                                    <div class="card-header border-0 bg-primary p-2">
                                        <h6 class="row m-0 text-center text-light" style="font-size:18px">Filtrar Foros</h6>
                                    </div>
                                    <center>
                                    <div class="row col-xl-12 pt-3">
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                            <div class="card-body p-0">
                                                <select id="txt-semestre" name="txt-semestre" class="form-control"></select>
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                            <div class="card-body p-0">
                                                <select id="txt-asignatura" name="txt-asignatura" class="form-control">
                                                    <option selected disabled value="">Selecciona una Ud. Didáctica</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                            <div class="card-body p-0">
                                                <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm ms-sm-2 ms-0 mt-sm-0 mt-2">Crear Foro</button>
                                            </div>
                                        </div>
                                    </div>
                                    </center>
                                </div>
                                <div class="card" style="height: 70%">
                                    <div class="card-header border-0 bg-primary p-2">
                                        <h6 class="row m-0 text-center text-light" style="font-size:18px">Foros creados</h6>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_Todo2" class="widget-media dlab-scroll height600  my-4 px-2">
                                            <ul class="timeline" id="list_foros">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!--column-->
                            <div class="col-xl-8">
                                <div class="card">
                                    {{-- <div class="card-header border-0 pb-0 justify-content-center"> --}}
                                    <div class="border-0 p-3 pb-0 justify-content-center">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item px-0">
                                                <div class="d-flex px-0 justify-content-between">
                                                    <h6 class="text-info"></h6>
                                                    <strong id="txt-autor" class="text"></strong>
                                                </div>
                                                <h3 id="txt-titulo" class="text-primary"></h3>
                                                <a id="txt-fecha_mod" href="javascript:void(0)" class="badge badge-rounded badge-outline-dark" style="font-size: 0.8rem"></a>
                                            </li>
                                            <li class="list-group-item px-0">
                                                <div class="overflow-auto-custom overflow-auto" style="max-height: 10rem">
                                                    <textarea id="txt-descripcion" class="form-control" rows="6" readonly></textarea>
                                                </div>
                                            </li>
                                            <li class="list-group-item px-0">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="card-body p-3 pt-0">
                                        <div class="card-header border-0 bg-primary p-2">
                                            <h6 class="row m-0 text-center text-light" style="font-size:18px">Respuestas</h6>
                                        </div>
                                        <div class="basic-list-group">
                                            <div id="list_respuestas" class="list-group">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer pt-0 pb-0 text-center">
                                        <div class="row">
                                            <div class="col-4 pt-3 pb-3 border-end">
                                                <h3 class="mb-1 text-primary">150</h3>
                                                <span>Alumnos</span>
                                            </div>
                                            <div class="col-4 pt-3 pb-3 border-end">
                                                <h3 class="mb-1 text-primary">140</h3>
                                                <span>Total Respuestas</span>
                                            </div>
                                            <div class="col-4 pt-3 pb-3">
                                                <h3 class="mb-1 text-primary">45</h3>
                                                <span>Tasks</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************-->


        <!--**********************************
            Content body end
        ***********************************-->
        <!-- Modal -->
        <form id="formModal">
            @csrf
            <div class="modal fade" id="modalCreateUpdate" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Nuevo Foro</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <!-- data -->
                                <input id="dt-idforum" name="dt-idforum" type="hidden" class="form-control form-control-sm">
                                <!-- data -->
                                <input id="dt-subject_id" name="dt-subject_id" type="hidden" class="form-control form-control-sm">
                                <!-- data -->
                                <div class="col-xl-12 mb-3">
                                    <label for="text_asignatura" class="form-label mb-2 fs-13 label-color font-w500">Ud. Didáctica Seleccionada</label>
                                    <input id="text_asignatura" name="text_asignatura" type="text" class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 mb-3">
                                    <label for="dt-titulo" class="form-label text-primary">Tema</label>
                                    <input id="dt-titulo" name="dt-titulo" type="text" class="form-control form-control-sm"  placeholder="Examen">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 mb-3">
                                    <label for="dt-descripcion" class="form-label text-primary">Descripcion</label>
                                    <textarea id="dt-descripcion" name="dt-descripcion" class="form-control" placeholder="Trabajo o examen de evaluación" rows="3">
                                    </textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 mb-3">
                                    <label for="dt-fecinicio" class="form-label text-primary">Fecha de Inicio</label>
                                    <input id="dt-fecinicio" name="dt-fecinicio" type="datetime-local" class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 mb-3">
                                    <label for="dt-fecfin" class="form-label text-primary">Fecha de Fin</label>
                                    <input id="dt-fecfin" name="dt-fecfin" type="datetime-local" class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger light btn-sm" data-bs-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-primary btn-sm" id="btnCreateUpdate">Registrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!--**********************************
        Footer start
        ***********************************-->
        @include('include.footer')
        <!--**********************************
        Footer end
        ***********************************-->
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);
    <script src="{{ asset('vendor/fullcalendar-5.11.0/lib/main.js') }}"></script>

    @vite(['resources/js/docente/foro.js']);


</body>

</html>
