<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Citas Presenciales</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')
    
    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">
        
        @include('include.nav_header')
        
        @extends('include.header')
        @section('titlenavbar')
            Gestionar Citas Presenciales
        @endsection
        
        @include('include.sidebar')
        
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Citas Presenciales</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Cita
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral" class="table table-bordered table-sm display rounded-3" style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha de la Cita</th>
                                                                <th class="text-center">DNI</th>
                                                                <th class="text-center">Nombres</th>
                                                                {{-- <th class="text-center">Email</th> --}}
                                                                {{-- <th class="text-center">Celular</th> --}}
                                                                {{-- <th class="text-center">Asunto</th> --}}
                                                                <th class="text-center">Trámite</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar datos de la Cita</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-id" name="txt-id" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nroidenti" class="form-label text-primary">N° DNI</label>
                                    <div class="input-group">
                                        <input id="txt-nroidenti" name="txt-nroidenti" type="number" autocomplete="off" class="form-control form-control-sm" placeholder="12345678" required>
                                        <a class="input-group-text bg-info text-white btn btn-sm rounded-pill" href="javascript:void(0);" id="btn-querydata" data-bs-placement="top" title="Consultar RENIEC"> <i class="fa fa-search"></i> </a>
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombres" class="form-label text-primary">Nombres</label>
                                    <input id="txt-nombres" name="txt-nombres" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-apellido_pa" class="form-label text-primary">Apellido Paterno</label>
                                    <input id="txt-apellido_pa" name="txt-apellido_pa" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-apellido_ma" class="form-label text-primary">Apellido Materno</label>
                                    <input id="txt-apellido_ma" name="txt-apellido_ma" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-email" class="form-label text-primary">Correo Electrónico</label>
                                    <input id="txt-email" name="txt-email" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-celular" class="form-label text-primary">Celular</label>
                                    <input id="txt-celular" name="txt-celular" type="number" class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-asunto" class="form-label text-primary">Asunto</label>
                                    <input id="txt-asunto" name="txt-asunto" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-datos_cita" class="form-label text-primary">Datos de Cita</label>
                                    <select id="txt-datos_cita" name="txt-datos_cita" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="Mesa de Partes">Mesa de Partes</option>
                                        <option value="Dirección General">Dirección General</option>
                                        <option value="Secretario Académico">Secretario Académico</option>
                                        <option value="Jefe Unidad Académica">Jefe Unidad Académica</option>
                                        <option value="Coordinación de Enfermería">Coordinación de Enfermería</option>
                                        <option value="Coordinación de Asistencia Administrativa">Coordinación de Asistencia Administrativa</option>
                                        <option value="Jefe de Investigación">Jefe de Investigación</option>
                                        <option value="Jefe de Formación Continua">Jefe de Formación Continua</option>
                                        <option value="Jefe de Empleabilidad y Bienestar Estudiantil">Jefe de Empleabilidad y Bienestar Estudiantil</option>
                                        <option value="Jefe de Calidad">Jefe de Calidad</option>
                                        <option value="Tesorería">Tesorería</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-user2_id" class="form-label text-primary">Usuario que atenderá la cita</label>
                                    <div class="input-group">
                                        <select id="txt-user2_id" name="txt-user2_id" class="default-select form-control form-control-sm" required>
                                            <option selected disabled value="">Seleccione opción</option>
                                        </select>
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date" class="form-control form-control-sm" required>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-horaini" class="form-label text-primary">Hora Inicio</label>
                                    <input id="txt-horaini" name="txt-horaini" type="time" class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                    <label for="txt-horafin" class="form-label text-primary">Hora Fin</label>
                                    <input id="txt-horafin" name="txt-horafin" type="time" class="form-control form-control-sm">
                                    {{-- @include('include.div.invalid-feedback') --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="1">Atendido</option>
                                        <option value="0">No Atendido</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/citas_presenciales/gestionar.js'])

</body>

</html>
