<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <!-- Meta -->
    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <title>Seguimiento del egresado</title>
    @include('include.datatable-styles')
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0">
    <link href="{{ asset('/css/style_inscripcion.css') }}" rel="stylesheet">
</head>

<body class="body h-100">
    <div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
        <div class="login-aside text-center  d-flex flex-column flex-row-auto">
            <div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15 align-items-center">
                <div class="text-center mb-lg-4 mb-2 pt-5 logo">
                    <img src="{{ route('institucion.cargarLogo') }}" alt="" width="80%">
                </div>
                <h3 class="mb-2 text-white">Seguimiento Egresado</h3>
                <p class="mb-4"><br>Sistema de Gestión Académica</p>
                <a href="{{ route('login') }}" class="btn btn-info btn-sm col-xl-6 mb-3">
                    <i class="fa-solid fa-user fa-flip"></i> Iniciar Sesión
                </a>
            </div>
        </div>
        <div class="container-fluid d-flex flex-column justify-content-start">
            <div class="row">
                <div class="col-xl-12">
                    <div class="row py-3">
                        <div class="form-validation">
                            <form class="needs-validation" id="form" name="form" novalidate>
                                <input id="hidden_student" name="hidden_student" type="hidden">
                                @csrf
                                <!-- Column starts -->
                                <div class="col-xl-12">
                                    <div class="card" id="accordion-three">
                                        <div class="card-header flex-wrap px-3 text-center">
                                            <div class="text-center">
                                                <h4 class="card-title"><i class="fas fa-cog fa-spin"></i>Datos del
                                                    Egresado</h4>
                                            </div>
                                        </div>
                                        <br>
                                        <br>
                                        <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                                <label for="txt_nroidenti" class="form-label text-primary">#
                                                    Identificación</label>
                                                <div class="input-group">
                                                    <input class="form-control form-control-sm" id="txt_nroidenti"
                                                        name="txt_nroidenti" placeholder="12345678" autocomplete="off"
                                                        type="text" required>
                                                    {{-- mensaje de error campo vacio --}}
                                                    <button class="btn btn-primary btn-sm" type="button"
                                                        id="btn-querydata"><i
                                                            class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                                        Validar
                                                    </button>
                                                    @include('include.div.invalid-feedback')
                                                </div>
                                            </div>
                                            <div class="col-xl-8 col-md-8 col-sm-8 col-12 mb-3 pt-4">
                                                <input type="hidden" id="text_descripcion" name="text_descripcion"
                                                    value="">
                                                <h3 id="txt_tipoUser_consulta"> </h3>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                        <div class="tab-content" id="myTabContent-2">
                                            <div class="tab-pane fade show active" id="withoutSpace" Aulae="tabpanel"
                                                aria-labelledby="home-tab-2">
                                                <div class="card-body p-4">
                                                    <div class="row">

                                                        <!-- data -->
                                                        <input id="txt_iduser" name="txt_iduser" type="hidden">

                                                        <!-- data -->
                                                        <div class="card"
                                                            style="border: 1px groove #ddd !important; margin: 0 0 1.5em 0 !important; -webkit-box-shadow: 0px 0px 0px 0px #000; box-shadow: 0px 0px 0px 0px #000;">
                                                            <div class="card-header" data-toggle="collapse"
                                                                href="#personalIdentification">
                                                                <legend class="text-primary mt-2"
                                                                    style="font-size: 1.2em !important;
                                                                            font-weight: bold !important;
                                                                            text-align: left !important;">
                                                                    <i class="fas fa-plus-circle"></i>
                                                                    <!-- Icono "+" -->
                                                                    <i class="fas fa-minus-circle d-none"></i>
                                                                    <!-- Icono "-" oculto por defecto -->
                                                                    IDENTIFICACIÓN PERSONAL
                                                                </legend>
                                                            </div>

                                                            <div class="collapse" id="personalIdentification">
                                                                <div class="card-body">
                                                                    <div
                                                                        class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                                                        <!-- Nombres -->
                                                                        <div
                                                                            class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                                                            <label for="txt_nombres"
                                                                                class="form-label text-primary">Nombres</label>
                                                                            <input id="txt_nombres" name="txt_nombres"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm text-uppercase"
                                                                                placeholder="Ingrese nombres" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacío --}}
                                                                        </div>

                                                                        <!-- Apellido Paterno -->
                                                                        <div
                                                                            class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt_apellido_pa"
                                                                                class="form-label text-primary">Apellido
                                                                                paterno</label>
                                                                            <input id="txt_apellido_pa"
                                                                                name="txt_apellido_pa" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm text-uppercase"
                                                                                placeholder="Ingrese apellido paterno"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacío --}}
                                                                        </div>

                                                                        <!-- Apellido Materno -->
                                                                        <div
                                                                            class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt_apellido_ma"
                                                                                class="form-label text-primary">Apellido
                                                                                materno</label>
                                                                            <input id="txt_apellido_ma"
                                                                                name="txt_apellido_ma" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm text-uppercase"
                                                                                placeholder="Ingrese apellido materno"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacío --}}
                                                                        </div>
                                                                    </div>
                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                    </div>


                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-12 mb-3">
                                                                            <label for="txt_carrera"
                                                                                class="form-label text-primary">Programa
                                                                                ó Módulo del que egresó</label>
                                                                            <input id="txt_carrera" name="txt_carrera"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE UNA Programa O MÓDULO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-2 mb-3">
                                                                            <label for="txt_ingreso"
                                                                                class="form-label text-primary">Año de
                                                                                ingreso</label>
                                                                            <input id="txt_ingreso" name="txt_ingreso"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="AÑO DE INGRESO" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data
                                                                <div class="col-2 mb-3">
                                                                    <label for="txt_termino"
                                                                        class="form-label text-primary">Año de término</label>
                                                                    <input id="txt_termino" name="txt_termino"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="AÑO DE TÉRMINO"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>
                                                                <div class="col-2 mb-3">
                                                                    <label for="txt_titulo"
                                                                        class="form-label text-primary">Año que se tituló</label>
                                                                    <input id="txt_titulo" name="txt_titulo"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="AÑO QUE SE TITULÓ"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>-->
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_domicilio"
                                                                                class="form-label text-primary">Domicilio</label>
                                                                            <input id="txt_domicilio"
                                                                                name="txt_domicilio" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE UN DOMICILIO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_correo"
                                                                                class="form-label text-primary">Correo
                                                                                Electrónico</label>
                                                                            <input id="txt_correo" name="txt_correo"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="AÑO DE INGRESO" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_celular"
                                                                                class="form-label text-primary">N de
                                                                                Celular</label>
                                                                            <input id="txt_celular" name="txt_celular"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="AÑO DE TÉRMINO" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>


                                                        <div class="card"
                                                            style="border: 1px groove #ddd !important;
                                                                            margin: 0 0 1.5em 0 !important;
                                                                            -webkit-box-shadow: 0px 0px 0px 0px #000;
                                                                            box-shadow: 0px 0px 0px 0px #000;">

                                                            <div class="card-header" data-toggle="collapse"
                                                                href="#actividadLaboral">
                                                                <legend class="text-primary mt-2"
                                                                    style="font-size: 1.2em !important;
                                                                        font-weight: bold !important;
                                                                        text-align: left !important;">
                                                                    <i class="fas fa-plus-circle"></i>
                                                                    <!-- Icono "+" -->
                                                                    <i class="fas fa-minus-circle d-none"></i>
                                                                    <!-- Icono "-" oculto por defecto -->
                                                                    ACTIVIDAD LABORAL
                                                                </legend>
                                                            </div>

                                                            <div class="collapse" id="actividadLaboral">
                                                                <div class="card-body">
                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-2 mb-3">
                                                                            <label for="txt_trabaja"
                                                                                class="form-label text-primary">¿Actualmente
                                                                                trabaja?</label>
                                                                            <select id="txt_trabaja"
                                                                                name="txt_trabaja"
                                                                                class="default-select form-control form-control-sm"
                                                                                required>
                                                                                <option selected value="No">No
                                                                                </option>
                                                                                <option value="Sí">Sí
                                                                                </option>
                                                                            </select>

                                                                        </div>
                                                                        <!-- data -->
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_nomempresa"
                                                                                class="form-label text-primary">Nombre
                                                                                de la empresa</label>
                                                                            <input id="txt_nomempresa"
                                                                                name="txt_nomempresa" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE EL NOMBRE DE LA EMPRESA"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-2 mb-3">
                                                                            <label for="txt_tipoempresa"
                                                                                class="form-label text-primary">Tipo de
                                                                                empresa</label>
                                                                            <input id="txt_tipoempresa"
                                                                                name="txt_tipoempresa" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="TIPO DE EMPRESA" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-2 mb-3">
                                                                            <label for="txt_remuneracion"
                                                                                class="form-label text-primary">Remuneración
                                                                                mensual</label>
                                                                            <input id="txt_remuneracion"
                                                                                name="txt_remuneracion" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESO MENSUAL" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_rubro"
                                                                                class="form-label text-primary">Actividad/Rubro</label>
                                                                            <input id="txt_rubro" name="txt_rubro"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE UNA ACTIVIDAD O RUBRO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_civil"
                                                                                class="form-label text-primary">Estado
                                                                                Civil</label>
                                                                            <input id="txt_civil" name="txt_civil"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE UN ESTADO CIVIL"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_numhijos"
                                                                                class="form-label text-primary">Número
                                                                                de hijos</label>
                                                                            <input id="txt_numhijos"
                                                                                name="txt_numhijos" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE SU NÚMERO DE HIJOS"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_tipovivienda"
                                                                                class="form-label text-primary">Tipo de
                                                                                vivienda</label>
                                                                            <input id="txt_tipovivienda"
                                                                                name="txt_tipovivienda" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE SU TIPO DE VIVIENDA"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data
                                                                <div class="col-3 mb-3">
                                                                    <label for="txt_empresadireccion"
                                                                        class="form-label text-primary">Dirección</label>
                                                                    <input id="txt_empresadireccion" name="txt_empresadireccion"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="INGRESE UNA DIRECCIÓN"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>
                                                                <div class="col-3 mb-3">
                                                                    <label for="txt_empresatelefono"
                                                                        class="form-label text-primary">Teléfono</label>
                                                                    <input id="txt_empresatelefono" name="txt_empresatelefono"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="INGRESE UN NÚMERO DE TELÉFONO"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>
                                                                <div class="col-3 mb-3">
                                                                    <label for="txt_empresacorreo"
                                                                        class="form-label text-primary">Correo electrónico</label>
                                                                    <input id="txt_empresacorreo" name="txt_empresacorreo"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="INGRESO UN CORREO"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>-->

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_jefe"
                                                                                class="form-label text-primary">Nombre
                                                                                de su jefe inmediato</label>
                                                                            <input id="txt_jefe" name="txt_jefe"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE EL NOMBRE DE SU JEFE INMEDIATO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_cargo"
                                                                                class="form-label text-primary">Cargo</label>
                                                                            <input id="txt_cargo" name="txt_cargo"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESE UN CARGO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!--
                                                                <div class="col-4 mb-3">
                                                                    <label for="txt_sintrabajar"
                                                                        class="form-label text-primary">Desde que egresó ¿Cuánto tiempo a estado sin trabajar?</label>
                                                                    <input id="txt_sintrabajar" name="txt_sintrabajar"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder=""
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>

                                                            </div>

                                                            <div
                                                                class="row m-0 p-0 col-12 mb-3">
                                                                <div class="col-2 mb-3">
                                                                    <label for="txt_condicionlaboral"
                                                                        class="form-label text-primary">Condición laboral</label>
                                                                    <input id="txt_condicionlaboral" name="txt_condicionlaboral"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder="INGRESE SU CONDICIÓN LABORAL"
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>
                                                                <!-- data -->
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_formacontrato"
                                                                                class="form-label text-primary">Forma
                                                                                de contrato</label>
                                                                            <input id="txt_formacontrato"
                                                                                name="txt_formacontrato"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="FORMA DE CONTRATO"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <div class="col-3 mb-3">
                                                                            <label for="txt_gastos"
                                                                                class="form-label text-primary">Gastos
                                                                                mensuales</label>
                                                                            <input id="txt_gastos" name="txt_gastos"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="INGRESO SUS GASTOS MESNUALES"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!--
                                                                <div class="col-8 mb-3">
                                                                    <label for="txt_notrabaja"
                                                                        class="form-label text-primary">En caso no estuviera trabajando, explique porque</label>
                                                                    <input id="txt_notrabaja" name="txt_notrabaja"
                                                                        type="text" autocomplete="off"
                                                                        class="form-control form-control-sm"
                                                                        placeholder=""
                                                                        required>
                                                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                                                </div>-->

                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <div class="card"
                                                            style="border: 1px groove #ddd !important;
                                                            margin: 0 0 1.5em 0 !important;
                                                            -webkit-box-shadow: 0px 0px 0px 0px #000;
                                                            box-shadow: 0px 0px 0px 0px #000;">

                                                            <div class="card-header" data-toggle="collapse"
                                                                href="#evaluacionFormacion">
                                                                <legend class="text-primary mt-2"
                                                                    style="font-size: 1.2em !important;
                                                                                font-weight: bold !important;
                                                                                text-align: left !important;">
                                                                    <i class="fas fa-plus-circle"></i>
                                                                    <!-- Icono "+" -->
                                                                    <i class="fas fa-minus-circle d-none"></i>
                                                                    <!-- Icono "-" oculto por defecto -->
                                                                    EVALUACIÓN DE LA FORMACIÓN
                                                                </legend>
                                                            </div>

                                                            <div class="collapse" id="evaluacionFormacion">
                                                                <div class="card-body">


                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-4 mb-3">
                                                                            <label for="txt_anteriormente"
                                                                                class="form-label text-primary">¿Anteriormente
                                                                                estuvo trabajando?</label>
                                                                            <input id="txt_anteriormente"
                                                                                name="txt_anteriormente"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div class="col-8 mb-3">
                                                                            <label for="txt_negativopositivo"
                                                                                class="form-label text-primary">Si la
                                                                                respuesta es negativa o positiva,
                                                                                ingresar el tiempo en meses</label>
                                                                            <input id="txt_negativopositivo"
                                                                                name="txt_negativopositivo"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_porque"
                                                                                class="form-label text-primary">¿Porque?</label>
                                                                            <input id="txt_porque" name="txt_porque"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_explicacionlaboral"
                                                                                class="form-label text-primary">A
                                                                                partir de su experiencia laboral, la
                                                                                formación profesional que recibió
                                                                                es:</label>
                                                                            <input id="txt_explicacionlaboral"
                                                                                name="txt_explicacionlaboral"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <!-- data -->
                                                                        <div class="col-12 mb-3">
                                                                            <label for="txt_satisface"
                                                                                class="form-label text-primary">¿La
                                                                                Programa profesional que estudió
                                                                                satisface las necesidades de la
                                                                                localidad o región?</label>
                                                                            <input id="txt_satisface"
                                                                                name="txt_satisface" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>


                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <!-- data -->
                                                                        <div class="col-12 mb-3">
                                                                            <label for="txt_beneficiado"
                                                                                class="form-label text-primary">¿Qué
                                                                                área de su Programa profesional es el más
                                                                                que le a beneficiado en su desempeño
                                                                                laboral?</label>
                                                                            <input id="txt_beneficiado"
                                                                                name="txt_beneficiado" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>


                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <!-- data -->
                                                                        <div class="col-12 mb-3">
                                                                            <label for="txt_conforme"
                                                                                class="form-label text-primary">¿Usted
                                                                                se siente conforme o satisfecho con la
                                                                                formación que la institución le
                                                                                brindó?</label>
                                                                            <input id="txt_conforme"
                                                                                name="txt_conforme" type="text"
                                                                                autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <!-- data -->
                                                                        <div class="col-12 mb-3">
                                                                            <label for="txt_motivos"
                                                                                class="form-label text-primary">Señale
                                                                                los motivos por los que está satisfecho
                                                                                con la formación recibida</label>
                                                                            <input id="txt_motivos" name="txt_motivos"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                    <div class="row m-0 p-0 col-12 mb-3">
                                                                        <!-- data -->
                                                                        <div class="col-6 mb-3">
                                                                            <label for="txt_motivos_razon"
                                                                                class="form-label text-primary">Si la
                                                                                respuesta es negativa, indique la
                                                                                razón</label>
                                                                            <input id="txt_motivos_razon"
                                                                                name="txt_motivos_razon"
                                                                                type="text" autocomplete="off"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>

                                                                    </div>

                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer text-lg-end text-end">
                                                    <button id="btnSavetramitedoc" type="button"
                                                        class="btn btn-primary btn-sm ">Registrar</button>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                    </div>
                                </div>
                                <!-- Column ends -->
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- vendors -->
    <script src="{{ asset('/vendor/global/global.min.js') }}"></script>
    <script src="{{ asset('/vendor/jquery-nice-select/js/jquery.nice-select.min.js') }}"></script>
    <script src="{{ asset('/vendor/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>
    <script src="{{ asset('/vendor/sweetalert2/dist/sweetalert2.min.js') }}"></script>
    <!-- Toastr -->
    <script src="{{ asset('/vendor/toastr/js/toastr.min.js') }}"></script>
    <!-- All init script -->
    <script src="{{ asset('/js/plugins-init/toastr-init.js') }}"></script>


    @vite(['resources/js/alumno/egresado.js']);


    <script>
        // Agrega un manejador de eventos para cambiar los iconos al hacer clic en el encabezado
        $('.card-header').click(function() {
            $(this).find('.fa-plus-circle, .fa-minus-circle').toggleClass('d-none');
        });
    </script>
</body>

</html>
