<!DOCTYPE html>
<html lang="es" class="h-100">

<head>
    @include('include.meta-favicon')
    @include('include.plugins-styles')

    <title>Restablecer contraseña</title>

    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-image:
                url('{{ asset('images/institucion/fondo_login.png') }}'),
                linear-gradient(180deg, #552f19, #b8b8b8);
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        #btn-reset {
            background-color: #050c58;
        }

        #btn-reset:hover {
            background-color: rgb(19, 16, 196);
        }

        .input-group-text {
            cursor: pointer;
        }

        .fa-eye-slash {
            display: none;
        }

        .showing .fa-eye {
            display: none;
        }

        .showing .fa-eye-slash {
            display: inline;
        }
    </style>
</head>

<body class="d-flex justify-content-center align-items-center vh-100">
    <form method="POST" action="{{ route('reset-password') }}" id="reset-form">
        @csrf
        <input type="hidden" name="token" value="{{ $token }}">

        <div class="bg-white p-4 rounded-5 text-secondary shadow" style="width: 25rem">
            <div class="text-center">
                <img class="img1 move-1 mb-4" src="{{ asset('images/institucion/logo.png') }}" alt=""
                    width="100px">
                <h3 class="text-center mb-2 text-black">Restablecer contraseña</h3>
                <p class="text-muted fs-6">Ingresa tu nueva contraseña y confírmala.</p>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label mb-2 fs-13 label-color font-w500">Correo electrónico</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input type="email" class="form-control" id="email" name="email" value="{{ $email }}"
                        readonly required>
                </div>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label mb-2 fs-13 label-color font-w500">Nueva contraseña</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                    <input type="password" class="form-control" id="password" name="password" required>
                    <span class="input-group-text toggle-password" data-target="#password">
                        <i class="fa fa-eye-slash"></i>
                        <i class="fa fa-eye"></i>
                    </span>
                </div>
            </div>

            <div class="mb-3">
                <label for="password_confirmation" class="form-label mb-2 fs-13 label-color font-w500">
                    Confirmar contraseña
                </label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                    <input type="password" class="form-control" id="password_confirmation" name="password_confirmation"
                        required>
                    <span class="input-group-text toggle-password" data-target="#password_confirmation">
                        <i class="fa fa-eye-slash"></i>
                        <i class="fa fa-eye"></i>
                    </span>
                </div>
            </div>

            <button class="btn btn-block btn-primary w-100" id="btn-reset">Restablecer contraseña</button>

            <div class="text-center mt-3">
                <a href="{{ url('/login') }}" class="text-primary">← Volver al inicio de sesión</a>
            </div>
        </div>
    </form>
</body>

@include('include.plugins-scripts')

<script src="{{ asset('js/custom.min.js') }}"></script>
<script src="{{ asset('js/dlabnav-init.js') }}"></script>

@vite(['resources/js/auth/reset-password.js'])

</html>
