<!DOCTYPE html>
<html lang="es">

<head>
    @include('include.meta-favicon')
    @include('include.plugins-styles')
    <title>Actividades y Tareas</title>
    @include('include.datatable-styles')
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <script>
        const APP_URL = "{{ url('/') }}";
    </script>

    <!-- ESTILOS NECESARIOS PARA LOS SELECTS -->
    <style>
        .nice-select.wide {
            width: 100% !important;
        }

        .nice-select .option {
            white-space: normal !important;
            height: auto !important;
            min-height: 40px;
            padding: 10px 15px;
            line-height: 1.3;
            border-bottom: 1px solid #f4f4f4;
            display: flex;
            align-items: center;
        }

        .nice-select .current {
            display: block;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            width: 95%;
        }

        .nice-select .list {
            width: 100% !important;
            max-height: 300px;
            overflow-y: auto !important;
        }
    </style>
</head>

<body>
    @include('include.preloader')

    <div id="main-wrapper">
        @include('include.nav_header')
        @extends('include.header')
        @section('titlenavbar')
            Mis Tareas
        @endsection
        @include('include.sidebar')

        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <!-- FILTROS -->
                    <div class="col-xl-4 col-xxl-4">
                        <div class="card">
                            <div class="card-header d-block">
                                <h4 class="card-title text-primary mb-3">Filtros Académicos</h4>
                                <div class="basic-form">

                                    <!-- SELECT PERIODO -->
                                    <div class="mb-5 pb-4">
                                        <label class="form-label text-dark fw-bold">1. Periodo Académico</label>
                                        <select id="cbo_periodo" class="form-control form-control-sm wide">
                                            <option value="0">Cargando periodos...</option>
                                        </select>
                                    </div>

                                    <!-- SELECT CURSO -->
                                    <div class="mb-4">
                                        <label class="form-label text-dark fw-bold">2. Unidad Didáctica / Asignatura</label>
                                        <select id="cbo_curso" class="form-control form-control-sm wide">
                                            <option value="0">Esperando periodo...</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="text-center mt-2">
                                    <p class="text-muted mt-2 small">Seleccione un periodo y luego un curso para ver sus
                                        calificaciones.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- RESULTADOS -->
                    <div class="col-xl-8 col-xxl-8">
                        <div class="card">
                            <div class="card-header border-0 pb-0">
                                <div>
                                    <h4 class="card-title text-primary">Listado de Actividades</h4>
                                    <span class="text-muted small" id="lbl_nombre_curso_seleccionado">Ningún curso
                                        seleccionado</span>
                                </div>
                            </div>
                            <div class="card-body" style="min-height: 500px;">
                                <div id="lista_tareas_contenido" class="pt-4">
                                    <div class="text-center mt-5">
                                        <h5 class="text-muted">Esperando selección de curso...</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('include.footer')
    </div>

    <div class="modal fade" id="modalSubirTarea" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white">Subir Tarea / Evidencia</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formSubirTarea" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="hdn_asignatura_id" name="asignatura_id">
                    <input type="hidden" id="hdn_nota_id" name="nota_id">

                    <div class="mb-3">
                        <label class="form-label fw-bold" id="lbl_nombre_tarea">Actividad:</label>
                        <input type="text" class="form-control" id="txt_nombre_mostrar" readonly disabled>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Seleccione su archivo:</label>
                        <input type="file" class="form-control" name="file_tarea" id="file_tarea" required>
                        <small class="text-muted">Formatos: PDF, Word, Imagen y Zip</small>
                    </div>
                    
                    <div id="upload-progress" class="progress mt-3 d-none">
                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 100%">Subiendo...</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Tarea</button>
                </div>
            </form>
        </div>
    </div>
</div>


    @include('include.plugins-scripts')
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js'])
    @vite(['resources/js/alumno/tarea.js'])
</body>

</html>
