<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Publicaciones</title>

    @include('include.datatable-styles')

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">



    <style>
        .card-custom {
            border: none;
            border-radius: 1rem;
            overflow: hidden;
            transition: all 0.3s ease-in-out;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .card-custom:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.2);
        }

        .card-custom img {
            object-fit: cover;
            height: 200px;
            width: 100%;
        }

        .card-custom .card-body {
            padding: 1.2rem;
        }

        .card-title {
            font-weight: 600;
        }

        .card-text {
            color: #6c757d;
        }
    </style>

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Publicaciones
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <h4 class="mb-4">Publicaciones</h4>

                <div id="publicacionesContainer">
                    <!-- Aquí JS insertará las publicaciones -->
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->

        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js'])

    <!--  Page JS -->
    @vite(['resources/js/alumno/publicaciones.js'])

</body>

</html>