<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Ofertas Laborales</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Ofertas Laborales
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- BARRA DE BUSQUEDA -->
                <div class="card mb-0">
                    <div class="card-body pb-xl-4 pb-sm-3 pb-0">
                        <div class="row">
                            {{-- <div class="col-xl-3 col-xxl-4 col-lg-4 col-sm-6 col-12 my-2"> --}}
                            <div class="row col-xl-12">
                                <!-- FILTRO -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <div class="input-group d-flex align-items-center">
                                        <a href="javascript:void(0);" class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1" data-bs-placement="top">
                                            <i class="fas fa-city fa-lg"></i>
                                        </a>
                                        <label class="form-label mb-0"><b>Seleccione una ciudad</b></label>
                                    </div>
                                    <select id="txt-departamentos" class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto" data-live-search="true" data-size="8">
                                        <option value="all" namedepartamento="all">Todas las ciudades</option>
                                        <option value="01" namedepartamento="Amazonas"> Amazonas</option>
                                        <option value="02" namedepartamento="Ancash"> Ancash</option>
                                        <option value="03" namedepartamento="Apurimac"> Apurimac</option>
                                        <option value="04" namedepartamento="Arequipa"> Arequipa</option>
                                        <option value="05" namedepartamento="Ayacucho"> Ayacucho</option>
                                        <option value="06" namedepartamento="Cajamarca"> Cajamarca</option>
                                        <option value="24" namedepartamento="Callao"> Callao</option>
                                        <option value="07" namedepartamento="Cusco"> Cusco</option>
                                        <option value="08" namedepartamento="Huancavelica"> Huancavelica</option>
                                        <option value="09" namedepartamento="Huanuco"> Huanuco</option>
                                        <option value="10" namedepartamento="Ica"> Ica</option>
                                        <option value="11" namedepartamento="Junin"> Junin</option>
                                        <option value="12" namedepartamento="La Libertad"> La Libertad</option>
                                        <option value="13" namedepartamento="Lambayeque"> Lambayeque</option>
                                        <option value="14" namedepartamento="Lima"> Lima</option>
                                        <option value="15" namedepartamento="Loreto"> Loreto</option>
                                        <option value="16" namedepartamento="Madre de Dios"> Madre de Dios</option>
                                        <option value="17" namedepartamento="Moquegua"> Moquegua</option>
                                        <option value="18" namedepartamento="Pasco"> Pasco</option>
                                        <option value="19" namedepartamento="Piura"> Piura</option>
                                        <option value="20" namedepartamento="Puno"> Puno</option>
                                        <option value="21" namedepartamento="San Martin"> San Martin</option>
                                        <option value="22" namedepartamento="Tacna"> Tacna</option>
                                        <option value="23" namedepartamento="Tumbes"> Tumbes</option>
                                        <option value="25" namedepartamento="Ucayali"> Ucayali</option>
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <div class="input-group d-flex align-items-center">
                                        <a href="javascript:void(0);" class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1" data-bs-placement="top">
                                            <i class="fas fa-bars-staggered fa-lg"></i>
                                        </a>
                                        <label class="form-label mb-0"><b>Seleccione una Categoría</b></label>
                                    </div>
                                    <select id="txt-categorias" class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto" data-live-search="true" data-size="8">
                                        <option>Todas las categorías</option>
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <div class="input-group d-flex align-items-center">
                                        <a href="javascript:void(0);" class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1" data-bs-placement="top">
                                            <i class="fas fa-building fa-lg"></i>
                                        </a>
                                        <label class="form-label mb-0"><b>Seleccione una Empresa</b></label>
                                    </div>
                                    <select id="txt-empresas" class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto"
                                        data-live-search="true" data-size="8">
                                        <option>Todas las empresas</option>
                                    </select>
                                </div>
                                <!-- BUSCAR POR TEXTO -->
                                <div class="col-xl-3 col-xxl-12 col-lg-12 col-sm-6 col-12 my-2">
                                    <label class="form-label mb-2 mt-1"><b>Busque aquí su puesto</b></label>
                                    <div class="input-group">
                                        <input type="search" name="txt-buscartexto" id="txt-buscartexto"
                                            class="form-control form-control-sm">
                                        <a id="btnBuscarTexto" href="javascript:void(0);"
                                            class="input-group-text btn-primary rounded text-light" data-bs-placement="top"
                                            title="Buscar"><i class="fa-solid fa-magnifying-glass"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- VISTA DE TRABAJOS -->
                <div class="row">
                    <div class="col-xl-9">
                        <div class="mt-4 d-flex justify-content-between align-items-center flex-wrap">
                            <div class="mb-2">
                                <p class="mb-1 fs-16" id="info-filtros">Sin filtros aplicados</p>
                            </div>
                            <div class="d-flex align-items-center mb-4">
                                <div class="default-tab job-tabs">
                                    <ul class="nav nav-tabs" role="tablist">
                                        {{-- vista 1 --}}
                                        <li id="modo-vista-1" class="nav-item">
                                            <a class="nav-link active" data-bs-toggle="tab" href="#Boxed">
                                                <i class="fas fa-th-large"></i>
                                            </a>
                                        </li>
                                        {{-- vista 2 --}}
                                        <li id="modo-vista-2" class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#List1">
                                                <i class="fas fa-list"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div>
                                    <select class="default-select dashboard-select border-0" id="orden_ofertas">
                                        <option value="desc" data-display="Reciente">Más Reciente</option>
                                        <option value="asc">Más Antiguo</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <!-- VISUALIZACIÓN EN GRILLA -->
                            <div class="tab-pane fade show active" id="Boxed" role="tabpanel">
                                <!-- CARDS -->
                                <div class="row" id="lista_ofertas_laborales">
                                </div>
                            </div>
                            <!-- VISUALIZACIÓN EN LISTA -->
                            <div class="tab-pane fade" id="List1">
                                <div class="row">
                                    <!-- CARDS -->
                                    <div class="col-xl-12" id="lista2_ofertas_laborales">
                                    </div>
                                </div>
                            </div>
                            <!-- NAVEGACIÓN - INICIO -->
                            <div class="d-flex align-items-center justify-content-between flex-wrap">
                                <div class="mb-sm-0 mb-3">
                                    <p class="mb-1" id="info_cantidad_bot">--</p>
                                    <p class="mb-1" id="info_total_bot">--</p>
                                </div>
                                <nav>
                                    <ul id="nro_pagina" class="pagination pagination-circle">
                                        <li class="page-item page-indicator">
                                            <a class="page-link" href="javascript:void(0)">
                                                <i class="la la-angle-left"></i></a>
                                        </li>
                                        <li class="page-item active"><a class="page-link"
                                                href="javascript:void(0)">1</a>
                                        </li>
                                        <li class="page-item"><a class="page-link" href="javascript:void(0)">2</a>
                                        </li>
                                        </li>
                                        <li class="page-item page-indicator">
                                            <a class="page-link" href="javascript:void(0)">
                                                <i class="la la-angle-right"></i></a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                            <!-- NAVEGACIÓN - FIN -->
                        </div>
                    </div>
                    <!-- VISTA PREVIA DE OFERTA LABORAL -->
                    <div class="col-xl-3 mt-4">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="mb-0">Vista Previa</h4>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-header bg-blue">
                                        <div class="researcher">
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <span class="text-center d-block block">
                                            <span class="mb-2">
                                                <img src="../storage/companies/default/logo.png" width="141"
                                                    height="141" class="rounded-pill">
                                            </span>
                                        </span>
                                        <h4 class="fs-20 mb-0 text-center" id="preview-puesto">Puesto</h4>
                                        <span class="fw-bold mb-3 d-block text-center"
                                            id="preview-nombrecompany">Empresa</span>

                                        <p class="fs-14" id="preview-descripcion">Descripción de la oferta laboral
                                        </p>
                                        <div>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Vacantes: <span
                                                    class="ms-1" id="preview-vacantes"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Tipo: <span
                                                    class="ms-1" id="preview-tipo"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Modalidad: <span
                                                    class="ms-1" id="preview-modalidad"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Experiencia: <span
                                                    class="ms-1" id="preview-experiencia"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Fecha de publicación:
                                                <span class="ms-1" id="preview-fecpublicacion"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Fecha de cierre: <span
                                                    class="ms-1" id="preview-feccierre"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Rango salarial: <span
                                                    class="ms-1" id="preview-rangosalarial"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Nivel educativo: <span
                                                    class="ms-1" id="preview-nivel_educativo"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Categoría: <span
                                                    class="ms-1" id="preview-nombrecategory"> ?</span></span>
                                            <span class="mb-2 d-flex"><i
                                                    class="fas fa-star orange me-2 mt-1"></i>Ubicación: <span
                                                    class="ms-1" id="preview-ubicacion"> ?</span></span>
                                        </div>
                                    </div>
                                    <div class="card-footer border-0 pt-0">
                                        <div class="d-flex justify-content-center align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-primary btn-rounded"
                                                id="btnModalPostular">Postular</a>
                                            {{-- <a href="javascript:void(0);"
                                                class="btn btn-secondary  btn-sm btn-rounded light"><i
                                                    class="far fa-bookmark fs-20"></i></a> --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalPostular" class="modal fade" tabindex="-1" aria-labelledby="modalPostularLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalPostularLabel">Enviar CV para postular</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idjob" name="txt-idjob">
                                <input type="hidden" id="txt-idcompany" name="txt-idcompany">
                                <!-- data -->
                                <div id="div-txt-documento" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary"><b>Sube tu
                                        Curriculum Vitae</b> (Debe pesar maximo 2 MB y estar en formato PDF, PNG o JPG)</label>
                                    <input id="txt-documento" name="txt-documento" type="file"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnPostular" type="button" class="btn btn-primary btn-sm ">Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>




    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/alumno/ofertas_laborales.js'])

</body>

</html>
