<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Notas del Estudiante</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')

        @section('titlenavbar')
            {{ __('Nota del Estudiante') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-primary">
                                    <div
                                        class="card-header border-1 border-light bg-primary pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-folder"></i> Info. del Programa</h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Código: </h4>
                                                <h4 id="txt-codprograma" class="mb-0">--</h4>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Nombre: </h4>
                                                <h4 id="txt-programa" class="mb-0">--</h4>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Nivel Formativo: </h4>
                                                <h4 id="txt-nivel_formativo" class="mb-0">--</h4>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-primary">
                                    <div
                                        class="card-header border-1 border-light bg-primary pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-folder"></i> Info. del Plan</h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Nombre: </h4>
                                                <h4 id="txt-plan" class="mb-0">--</h4>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Tipo: </h4>
                                                <h4 id="txt-tipo" class="mb-0">--</h4>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Modalidad y Enfoque: </h4>
                                                <h4 id="txt-modalidad_enfoque" class="mb-0">--</h4>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-primary">
                                    <div
                                        class="card-header border-1 border-light bg-primary pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-folder"></i> Info. del Periodo Lectivo</h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Año-Número: </h4>
                                                <select id="txt-semestre" name="txt-semestre"
                                                    class="">
                                                    <option value="" selected disabled>Periodo</option>
                                                </select>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Fecha de Inicio: </h4>
                                                <h4 id="txt-fecinicio" class="mb-0">--</h4>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <h4>Fecha de Fin: </h4>
                                                <h4 id="txt-fecfin" class="mb-0">--</h4>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!--  -->
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="d-flex justify-content-center">
                                                    <button id="btnPromedioAlumno" class="btn btn-primary" data-bs-placement="top" title="Ver Promedios">
                                                        Generar Acta de Notas
                                                    </button>
                                                </div>
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Plan</th>
                                                                <th class="text-center">Periodo</th>
                                                                <th class="text-center">Nombre curso</th>
                                                                <th class="text-center">Creditos-Horas</th>
                                                                <th class="text-center">Condicion</th>
                                                                <th class="text-center">Ver Notas</th>
                                                                <th class="text-center">Nota Final</th>
                                                                <th class="text-center">Estado</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')



    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalDetalleNotas" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleNotasLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDetalleNotasLabel">Detalles de Notas</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralEvaluaciones"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Promedio Final</th>
                                                                <th class="text-center">Indicador</th>
                                                                <th class="text-center">Actividad</th>
                                                                <th class="text-center">Nota</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    </div>

    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idperiod" name="txt-idperiod">
    </form>

    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';

    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/alumno/nota.js'])

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
