<!DOCTYPE html>
<html lang="es">

<head>
    @include('include.meta-favicon')
    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Horario del Estudiante</title>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        /* Aumentar la altura de cada slot de tiempo en week/day */
        .fc .fc-timegrid-slot {
            height: 2.5rem;
        }
    </style>

    {{-- FullCalendar CSS --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/6.1.19/index.global.min.css" />
</head>

<body>
    @include('include.preloader')

    <div id="main-wrapper">

        @include('include.nav_header')
        @extends('include.header')

        @section('titlenavbar')
            {{ __('Horario del Estudiante') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- ÚNICO CARD CON CALENDARIO -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Detalle del horario del estudiante</h4>
                                        </div>
                                        <div class="col-xl-3">
                                            <select id="txt_semestre" name="txt_semestre"
                                                class="default-select form-control form-control-sm form-control-primary">
                                                <option value="" selected disabled>Periodo</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="card-body p-2">
                                        {{-- AQUÍ VA EL CALENDARIO --}}
                                        <div id="calendar"></div>
                                    </div>
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->

        <!-- Modal Detalle de Unidad Didáctica / Foro -->
        <div class="modal fade" id="eventDetailModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="event-modal-title">
                            Detalle del curso
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                            aria-label="Cerrar"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-2" id="group-curso">
                            <strong>Unidad Didáctica:</strong>
                            <div id="event-title" class="text-primary fw-bold"></div>
                        </div>

                        <div class="row mb-2" id="group-fechas">
                            <div class="col-6">
                                <strong>Inicio:</strong>
                                <div id="event-start"></div>
                            </div>
                            <div class="col-6">
                                <strong>Fin:</strong>
                                <div id="event-end"></div>
                            </div>
                        </div>

                        <div class="row mb-2" id="group-aula-docente">
                            <div class="col-6">
                                <strong>Aula:</strong>
                                <div id="event-aula"></div>
                            </div>
                            <div class="col-6">
                                <strong>Docente:</strong>
                                <div id="event-docente"></div>
                            </div>
                        </div>

                        <div class="row mb-2" id="group-turno-seccion">
                            <div class="col-6">
                                <strong>Turno:</strong>
                                <div id="event-turno"></div>
                            </div>
                            <div class="col-6">
                                <strong>Sección:</strong>
                                <div id="event-seccion"></div>
                            </div>
                        </div>

                        <div class="mb-2" id="group-condicion">
                            <strong>Condición:</strong>
                            <div id="event-condicion"></div>
                        </div>

                        <!-- Solo para foros -->
                        <div class="mb-2 d-none" id="group-foro-descripcion">
                            <strong>Descripción del foro:</strong>
                            <div id="event-descripcion-foro"></div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary btn-sm" data-bs-dismiss="modal">
                            Cerrar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        @include('include.footer')
    </div>

    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idperiod" name="txt-idperiod">
    </form>

    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js'])

    {{-- FullCalendar JS --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/6.1.19/index.global.min.js"></script>

    {{-- Page JS (alumno) --}}
    @vite(['resources/js/alumno/horario.js'])
</body>

</html>
