<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Foros</title>

    <!-- FAVICONS ICON -->

    <link rel="stylesheet" href="{{ asset('/vendor/fullcalendar-5.11.0/lib/main.css') }}">

    <!-- Style css -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>

    <!--*******************
        Preloader start
    ********************-->
    @include('include.preloader')
    <!--*******************
        Preloader end
    ********************-->

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <!--**********************************
            Nav header start
        ***********************************-->
        @include('include.nav_header')
        @extends('include.header')
        @section('titlenavbar')
            Foros
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid pt-0">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <!-- Row -->
                        <div class="row">
                            <!--column-->
                            <div class="col-xl-3">
                                <div class="card mb-3" style="height: 20%">
                                    <div class="card-header border-0 bg-primary p-2">
                                        <h6 class="row m-0 text-center text-light" style="font-size:18px">Filtrar Foros</h6>
                                    </div>
                                    <center>
                                    <div class="row col-xl-12 pt-3">
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                            <div class="card-body p-0">
                                                <select id="txt-semestre" name="txt-semestre" class="form-control"></select>
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                            <div class="card-body p-0">
                                                <select id="txt-asignatura" name="txt-asignatura" class="form-control">
                                                    <option selected disabled value="">Selecciona una curso</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    </center>
                                </div>
                                <div class="card" style="height: 75%">
                                    <div class="card-header border-0 bg-primary p-2">
                                        <h6 class="row m-0 text-center text-light" style="font-size:18px">Foros creados</h6>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_Todo2" class="widget-media dlab-scroll height600  my-4 px-2">
                                            <ul class="timeline" id="list_foros">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!--column-->
                            <div class="col-xl-9">
                                <div class="card">
                                    {{-- <div class="card-header border-0 pb-0 justify-content-center"> --}}
                                    <div class="border-0 p-3 pb-0 justify-content-center">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item px-0">
                                                <div class="d-flex px-0 justify-content-between">
                                                    <h6 class="text-info"></h6>
                                                    <strong id="txt-autor" class="text"></strong>
                                                </div>
                                                <h3 id="txt-titulo" class="text-primary"></h3>
                                                <a id="txt-fecha_mod" href="javascript:void(0)" class="badge badge-rounded badge-outline-dark" style="font-size: 0.8rem"></a>
                                            </li>
                                            <li class="list-group-item px-0">
                                                <div class="overflow-auto-custom overflow-auto" style="max-height: 10rem">
                                                    <textarea id="txt-descripcion" class="form-control" rows="5" readonly></textarea>
                                                </div>
                                            </li>
                                            <li class="list-group-item px-0 pb-1">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="card-body p-3 pt-0">
                                        <div class="card-header border-0 bg-primary p-2">
                                            <h6 class="row m-0 text-center text-light" style="font-size:18px">Respuestas</h6>
                                        </div>
                                        <div class="basic-list-group">
                                            <div id="list_respuestas" class="list-group overflow-auto-custom overflow-auto" style="max-height: 30rem">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer p-3 text-center">
                                        <div class="card-header border-0 bg-primary p-2">
                                            <h6 class="row m-0 text-center text-light" style="font-size:18px">Escribe tu respuesta</h6>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <textarea id="txt-comentario" class="form-control mb-1 rounded-0" rows="2"></textarea>
                                            <button type="button" class="btn btn-primary btn-sm m-3" id="btnCreate">Registrar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************-->


        <!--**********************************
            Content body end
        ***********************************-->
        <form id="formModal">
            @csrf
            <div class="modal fade" id="modalCreateUpdate" tabindex="-1" aria-labelledby="modalCreateUpdateLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-center">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Actualizar respuesta del foro</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                                <!-- data -->
                                <input id="dt-iduser" name="dt-iduser" value="<?php echo Auth::User()->id; ?>" type="hidden" class="form-control form-control-sm">
                                <!-- data -->
                                <input id="dt-idforum" name="dt-idforum" type="hidden" class="form-control form-control-sm">
                                <!-- data -->
                                <input id="dt-idforumanswer" name="dt-idforumanswer" type="hidden" class="form-control form-control-sm">
                                <!-- data -->
                                <div class="col-xl-12 mb-3">
                                    <label for="dt-comentario" class="form-label text-primary">Escribe aquí:</label>
                                    <textarea id="dt-comentario" name="dt-comentario" class="form-control"  rows="3">
                                    </textarea>
                                </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger light btn-sm" data-bs-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-primary btn-sm" id="btnUpdate">Actualizar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>


        <!--**********************************
        Footer start
        ***********************************-->
        @include('include.footer')
        <!--**********************************
        Footer end
        ***********************************-->
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);
    <script src="{{ asset('vendor/fullcalendar-5.11.0/lib/main.js') }}"></script>

    @vite(['resources/js/alumno/foro.js']);

</body>

</html>
