<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Inicio Estudiante</title>
    @include('include.datatable-styles')
    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        /* Para imágenes horizontales */
        .horizontal-image {
            width: 100%; /* Ajustar el ancho al 100% */
            height: auto; /* Mantener la relación de aspecto */
        }

        /* Para imágenes verticales */
        .vertical-image {
            width: 50%; /* Ajustar el ancho a 50% */
            height: auto; /* Mantener la relación de aspecto */
        }
        </style>
</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Publicaciones') }}
        @endsection

        @include('include.sidebar')
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid mh-auto">
                <div class="row">
                    @csrf
                    @if (count($data) > 0)
                    <!-- Verifica si hay datos -->
                    @foreach ($data as $publicacion)
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-6  col-md-6 col-xxl-5 ">
                                        <!-- Tab panes -->
                                        <div class="tab-content text-center" id="myTabContent">
                                          <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
                                            <img class="img-fluid rounded dynamic-image"
                                            src="/alumno/publicaciones/viewimg/{{ $publicacion->id }}/{{ $publicacion->carpeta }}/{{ $publicacion->imagen }}"
                                            alt=""
                                            width="100%">
                                          </div>
                                        </div>
                                    </div>
                                    <!--Tab slider End-->
                                    <div class="col-xl-9 col-lg-6  col-md-6 col-xxl-7 col-sm-12">
                                        <div class="product-detail-content">
                                            <!--Product details-->
                                            <div class="new-arrival-content">
                                                <h4>{{ $publicacion->titulo }}</h4>
                                                <div class="comment-review star-rating d-flex">
                                                    <ul>
                                                        <li><i class="fa fa-star"></i></li>
                                                        <li><i class="fa fa-star"></i></li>
                                                        <li><i class="fa fa-star"></i></li>
                                                        <li><i class="fa fa-star"></i></li>
                                                        <li><i class="fa fa-star"></i></li>

                                                    </ul>
                                                    <span class="review-text ms-3">(34 like) / </span>
                                                </div>
                                                <div class="d-table mb-2">
                                                    <p class="price float-start d-block">{{ $publicacion->nombre }}</p>
                                                </div>
                                                <p><span class="item fs-14">Publicado:</span><i
                                                            class="fa fa-date"></i> {{ $publicacion->created_at }}
                                                </p>

                                                <p><span class="item fs-14">Estado</span>&nbsp;&nbsp;
                                                    <span class="badge badge-warning light">bags</span>
                                                    <span class="badge badge-success light">clothes</span>
                                                    <span class="badge badge-info light">shoes</span>
                                                    <span class="badge badge-danger light">dresses</span>
                                                </p>
                                                <p class="text-content">{!! $publicacion->contenido !!}</p>
                                                <div class="d-flex align-items-end flex-wrap">
													<div class="filtaring-area me-3">
														<div class="size-filter">
                                                            <a href="#"><span class="badge badge-dark light"><i class="fa-regular fa-heart"></i></span></a>
														</div>
													</div>
												</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    @endforeach
                    @else
                        <p>No hay publicacions disponibles.</p>
                    @endif
                </div>
            </div>
        </div>


        <!--**********************************
            Content body end
        ***********************************-->
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')


    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script>
        window.onload = function() {
            const images = document.querySelectorAll('.dynamic-image');

            images.forEach(image => {
                // Esperar a que la imagen se cargue
                image.onload = function() {
                    // Detectar la orientación de la imagen
                    if (image.naturalWidth < image.naturalHeight) {
                        // Imagen vertical
                        image.classList.add('vertical-image');
                    } else {
                        // Imagen horizontal
                        image.classList.add('horizontal-image');
                    }
                };

                // Si la imagen ya está cargada, se ejecuta de inmediato
                if (image.complete) {
                    image.onload();
                }
            });
        }
    </script>

</body>

</html>
