<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Esncuesta</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/preloader.css') }}" rel="stylesheet">

</head>

<body>
    <div id="progressSection" style="display: none;"> <!-- Contenedor de la barra de progreso, inicialmente oculto -->
        <div id="porcentaje">0</div>
        <div class="barra_progreso">
            <div class="progreso" id="progreso"></div>
        </div>
    </div>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Gestionar Preguntas de la Encuestas') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <!--column-->
                    <div class="col-xl-3 col-xxl-3 col-lg-3 col-md-12">
                        @if (count($data) > 0)
                        <!-- Verifica si hay datos -->
                        @foreach ($data as $encuesta)
                            <input type="hidden" name="id_encuesta" value="{{ $encuesta->id }}">
                            <div class="card">
                                <div class="card-header border-0 pb-0">
                                    <h6 class="card-title">Encuesta: {{ $encuesta->titulo }}</h6>
                                </div>
                                <div class="card-body pb-0">
                                    <p> <strong>Descripción:</strong> {{ $encuesta->descripcion }}</p>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Estado:</strong>
                                            <span class="mb-0">
                                                @if ($encuesta->estado == 'activa')
                                                    <span class="badge badge-success light">Activa</span>
                                                @else
                                                    <span class="badge badge-danger light">Inactiva</span>
                                                @endif
                                            </span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Fecha inicio</strong>
                                            <span class="mb-0">{{ $encuesta->fecha_inicio }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Fecha Fin</strong>
                                            <span class="mb-0">{{ $encuesta->fecha_fin }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Plan</strong>
                                            <span class="mb-0"> {{ $encuesta->nombre }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Tipo</strong>
                                            <span class="mb-0">{{ $encuesta->tipo }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Dirigido a:</strong>
                                            <span class="mb-0">{{ $encuesta->dirigido_a }}</span>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        @endforeach
                        @else
                            <p>No hay encuestas disponibles.</p>
                        @endif
                    </div>
                    <!--/column-->
                    <!--column-->

                    <div class="col-xl-9 col-xxl-9 col-lg-9 col-lg-12">
                        <div class="card">
                            <div class="card-header border-0 pb-0">
                                <div class="file-header border-0 w-100">
                                    <div class="page-titles">
                                        <div class="my-2">
                                            <h2 class="heading">Responder las preguntas</h2>
                                        </div>
                                        <div class="d-flex my-2">
                                            <div class="p-0">

                                                <button type="button" id="btn_ResponseQuestions"
                                                class="btn btn-primary btn-sm">Enviar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <form class="needs-validation" id="formRespuestas">
                                    @csrf
                                <ul id="DZ_W_TimeLine" class="widget-media dlab-scroll height600 my-4 px-4">
                                    @if (count($preguntas) > 0)
                                    <ul>
                                        @foreach ($preguntas as $pregunta)
                                            <div class="pregunta mb-4">
                                                @if ($pregunta->tipo === 'texto')
                                                    <li>
                                                        <div class="card schedule-card border">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <div>
                                                                        <h4 class="mb-0">{{ $pregunta->pregunta }}</h4>
                                                                        <p>Tipo: Respuesta de texto</p>
                                                                    </div>
                                                                </div>
                                                                <div class="mt-3">
                                                                    <textarea class="form-control" rows="4" name="pregunta_{{ $pregunta->id }}" id="preguntatext_{{ $pregunta->id }}"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @elseif ($pregunta->tipo === 'opcion_unica')
                                                    <li>
                                                        <div class="card schedule-card border">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <div>
                                                                        <h4 class="mb-0">{{ $pregunta->pregunta }}</h4>
                                                                        <p>Tipo: Selección única</p>
                                                                    </div>
                                                                </div>
                                                                <div class="mt-3">
                                                                    @foreach ($pregunta->opciones as $opcion)
                                                                        <div class="form-check mb-2">
                                                                            <input class="form-check-input" type="radio" id="pregunta_{{ $pregunta->id }}_opcion_{{ $opcion->id }}" name="pregunta_{{ $pregunta->id }}" value="{{ $opcion->id }}">
                                                                            <label class="form-check-label" for="pregunta_{{ $pregunta->id }}_opcion_{{ $opcion->id }}">
                                                                                {{ $opcion->contenido }}
                                                                            </label>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @elseif ($pregunta->tipo === 'multiple')
                                                    <li>
                                                        <div class="card schedule-card border">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <div>
                                                                        <h4 class="mb-0">{{ $pregunta->pregunta }}</h4>
                                                                        <p>Tipo: Selección múltiple</p>
                                                                    </div>
                                                                </div>
                                                                <div class="mt-3">
                                                                    @foreach ($pregunta->opciones as $opcion)
                                                                        <div class="form-check mb-2">
                                                                            <input class="form-check-input" type="checkbox" id="pregunta_{{ $pregunta->id }}_opcion_{{ $opcion->id }}" name="pregunta_{{ $pregunta->id }}[]" value="{{ $opcion->id }}">
                                                                            <label class="form-check-label" for="pregunta_{{ $pregunta->id }}_opcion_{{ $opcion->id }}">
                                                                                {{ $opcion->contenido }}
                                                                            </label>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @else
                                                    <p class="text-danger">Pregunta no identificada.</p>
                                                @endif
                                            </div>
                                        @endforeach
                                    </ul>
                                @else
                                    <p>No hay preguntas disponibles.</p>
                                @endif

                                </ul>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!--/column-->
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Full screen modal -->

    <div class="modal fade show" id="modalfinalizado" tabindex="-1" aria-labelledby="modalfinalizadoLabel" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-body p-0"> <!-- Eliminar el padding por defecto -->
                    <div class="text-center p-0 overlay-box" style="background-image: url({{ asset('images/big/rainbow.gif')}}); background-size: cover; background-position: center; height: 100%; display: flex; justify-content: center; align-items: center;">
                        <img src="images/profile/pic2.jpg" width="100" class="img-fluid rounded-circle" alt="">
                        <h3 class="mt-3 mb-0 text-white">¡ Felicidades, encuesta finalizada!</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')
    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/alumno/encuestas_preguntas_Ajax.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script>
        // Deshabilitar el cierre del modal con la tecla ESC
        var modal = document.getElementById('modalfinalizado');

        modal.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                event.preventDefault(); // Evita que el modal se cierre con ESC
            }
        });
    </script>

</body>

</html>











