<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Historial Asistencias</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>

<body>
    @include('include.preloader')

    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')

        @section('titlenavbar')
            {{ __('Historial de Asistencias') }}
        @endsection

        @include('include.sidebar')

        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 mx-auto">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light mb-0">Cursos</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsubject">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-8 col-lg-4 col-md-12 col-sm-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header px-3">
                                        <h4 class="card-title mb-0">
                                            Asistencias del Periodo:
                                        </h4>
                                    </div>

                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-2">
                                                <div id="attendanceSummary" class="my-3 px-3">
                                                    <div class="row gx-2 gy-2 text-center">

                                                        <div class="col-6 col-md-3">
                                                            <div class="border rounded-3 py-2 px-2 bg-white">
                                                                <span
                                                                    class="text-muted small d-block text-uppercase">Total
                                                                    clases</span>
                                                                <span id="att-total-classes"
                                                                    class="fw-bold fs-5 d-block">--</span>
                                                            </div>
                                                        </div>

                                                        <div class="col-6 col-md-3">
                                                            <div class="border rounded-3 py-2 px-2 bg-white">
                                                                <span
                                                                    class="text-muted small d-block text-uppercase">Asistencias</span>
                                                                <span id="att-total-asistencias"
                                                                    class="fw-bold fs-5 text-success d-block">--</span>
                                                            </div>
                                                        </div>

                                                        <div class="col-6 col-md-3">
                                                            <div class="border rounded-3 py-2 px-2 bg-white">
                                                                <span
                                                                    class="text-muted small d-block text-uppercase">Tardanzas</span>
                                                                <span id="att-total-tardanzas"
                                                                    class="fw-bold fs-5 text-warning d-block">--</span>
                                                            </div>
                                                        </div>

                                                        <div class="col-6 col-md-3">
                                                            <div class="border rounded-3 py-2 px-2 bg-white">
                                                                <span
                                                                    class="text-muted small d-block text-uppercase">Faltas</span>
                                                                <span id="att-total-faltas"
                                                                    class="fw-bold fs-5 text-danger d-block">--</span>
                                                            </div>
                                                        </div>

                                                        <div class="col-12 mt-2">
                                                            <div class="border rounded-3 py-2 px-2 bg-white">
                                                                <span
                                                                    class="text-muted small d-block text-uppercase">Porcentaje
                                                                    de asistencia</span>
                                                                <span id="att-percent-asistencia"
                                                                    class="fw-bold fs-4 text-primary d-block">--</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Clase</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Zoom</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('include.footer')

    </div>

    <form id="formModal" novalidate>
        @csrf
        <input id="txt-idsubjectclass" name="txt-idsubjectclass" type="hidden">
        <input id="txt-idsubjectenrollment" name="txt-idsubjectenrollment" type="hidden">
        <input id="txt-estado_asistencia" name="txt-estado_asistencia" type="hidden">
    </form>

    @include('include.plugins-scripts')
    @include('include.datatable-scripts')

    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <script>
        var logoutRoute = '{{ route('logout') }}';

        function joinZoomMeeting(idZoomMeeting, id_account, id_client, id_client_secret) {
            $('#zoom-loader-container').show();

            let data = {
                id_zoom_meeting: idZoomMeeting,
                id_account: id_account,
                id_client: id_client,
                id_client_secret: id_client_secret
            };

            let csrfToken = $('meta[name="csrf-token"]').attr('content');

            $.ajax({
                url: '/alumno/zoom/meeting',
                type: 'POST',
                data: JSON.stringify(data),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': csrfToken
                },
                success: function(response) {
                    $('#zoom-loader-container').hide();

                    if (response.join_url) {
                        window.open(response.join_url, '_blank');
                    } else {
                        alert('No se pudo obtener el link de la reunión. Detalles: ' + (response.error ||
                            'No se proporcionaron detalles.'));
                    }
                },
                error: function(xhr, status, error) {
                    $('#zoom-loader-container').hide();

                    console.error('Error al hacer la solicitud AJAX:', {
                        status: status,
                        error: error,
                        responseText: xhr.responseText
                    });

                    try {
                        let response = JSON.parse(xhr.responseText);
                        alert('Error: ' + (response.error || 'No se pudo obtener el link de la reunión.'));
                        console.error('Detalles del error:', response.details);
                    } catch (e) {
                        alert('Error inesperado al procesar la respuesta del servidor.');
                    }
                }
            });
        }
    </script>

    @vite(['resources/js/login/logout.js'])
    @vite(['resources/js/alumno/asistencia.js'])

    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
