<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Permisos a Módulos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Gestionar Permisos a Módulos
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <form class="needs-validation" id="formModal">
            @csrf
            <div class="content-body">
                <!-- row -->
                <div class="container-fluid">
                    <!-- Row -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="row">
                                <!-- Column starts -->
                                <div class="col-xl-12">
                                    <div class="card" id="accordion-three">
                                        <div class="card-header flex-wrap px-3">
                                            <div>
                                                <h4 class="card-title">Registro de información sobre permisos a los
                                                    Módulos</h4>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                        <div class="tab-content" id="myTabContent-2">
                                            <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                                aria-labelledby="home-tab-2">
                                                <div class="card-body p-4">
                                                    <div class="table-responsive">
                                                        <table id="datatableGeneral"
                                                            class="table table-bordered table-sm display rounded-3"
                                                            style="min-width:100%">
                                                            <input id="txt_idrol_name" name="txt_idrol_name"
                                                                type="hidden">
                                                            <input id="txt_idmodulo_name" name="txt_idmodulo_name"
                                                                type="hidden">
                                                            <input id="txt_permiso_name" name="txt_permiso_name"
                                                                type="hidden">
                                                            <input id="txt-action" name="txt-action" type="hidden">
                                                            <input id="txt-action_new_value" name="txt-action_new_value" type="hidden">
                                                            <thead class="thead-primary">
                                                                <tr>
                                                                    <th class="text-center">Cargo</th>
                                                                    <th class="text-center">Módulo</th>
                                                                    <th class="text-center">Permiso</th>
                                                                    <th class="text-center">Leer</th>
                                                                    <th class="text-center">Crear</th>
                                                                    <th class="text-center">Editar</th>
                                                                    <th class="text-center">Eliminar</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <!--  -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                    </div>
                                </div>
                                <!-- Column ends -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/seguridad/permisos.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
