<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Backups</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Backup de Base de Datos
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12 col-xxl-12 col-lg-12 col-md-12">
                                <!--row-->
                                <div class="card" id="accordion-three">
                                    @csrf
                                    <input type="hidden" id="hidden_archivozip" name="hidden_archivozip">
                                    <!--column-->
                                    <div class="col-xl-12">
                                        <div class="file-header">
                                            <div class="card-body py-0">
                                                <div class="page-titles">
                                                    <div class="my-2">
                                                        <h2 class="heading">Lista de Backups Realizados</h2>
                                                    </div>
                                                    <div class="d-flex my-2">

                                                            <input type="button"  class="btn btn-primary btn-sm" value="Generar backup" id="btn_generar_backup">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/column-->
                                    <!--column-->
                                    <div class="col-xl-12">
                                        <ul class="folder-structure dlab-scroll" id="folder">

                                        </ul>
                                    </div>
                                    <!--column-->
                                    <div class="col-xl-12">
                                        <div class="table-pagenation border-top bg-primary">
                                           <hr>
                                        </div>
                                    </div>
                                </div>
                                <!--/row-->

                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);
    <!--  Page JS -->
    @vite(['resources/js/admin/seguridad/backupBD.js']);
</body>

</html>
