<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Auditorías</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Auditorías
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Supervisión de actividad y auditorías</h4>
                                            <span class="text-muted small">
                                                Registro de acciones realizadas en el sistema
                                                (creación, actualización y eliminación de datos).
                                            </span>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <form id="filtersForm" class="row g-2 mb-3">
                                                    @csrf
                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Evento</label>
                                                        <select id="filter-event" class="form-control form-control-sm">
                                                            <option value="">Todos</option>
                                                            <option value="created">CREATED</option>
                                                            <option value="updated">UPDATED</option>
                                                            <option value="deleted">DELETED</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">ID Usuario</label>
                                                        <input id="filter-user-id" type="number"
                                                            class="form-control form-control-sm" placeholder="ID">
                                                    </div>

                                                    <div class="col-6 col-md-3">
                                                        <label class="form-label small mb-1">Nombre usuario</label>
                                                        <input id="filter-user-name" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="Nombre o apellidos">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Tipo usuario</label>
                                                        <input id="filter-user-type" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="App\Models\User">
                                                    </div>

                                                    <div class="col-6 col-md-3">
                                                        <label class="form-label small mb-1">Modelo</label>
                                                        <input id="filter-auditable-type" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="Pago, Classroom, Studentdocument">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">IP</label>
                                                        <input id="filter-ip" type="text"
                                                            class="form-control form-control-sm" placeholder="IP">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Desde</label>
                                                        <input id="filter-date-from" type="date"
                                                            class="form-control form-control-sm">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Hasta</label>
                                                        <input id="filter-date-to" type="date"
                                                            class="form-control form-control-sm">
                                                    </div>

                                                    <div
                                                        class="col-12 col-md-3 d-flex align-items-end justify-content-start gap-2 mt-2 mt-md-0">
                                                        <button type="button" id="btnFilter"
                                                            class="btn btn-primary btn-sm">
                                                            <i class="fas fa-search"></i> Buscar
                                                        </button>
                                                        <button type="button" id="btnClearFilters"
                                                            class="btn btn-secondary btn-sm">
                                                            Limpiar
                                                        </button>
                                                    </div>
                                                </form>

                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Evento</th>
                                                                <th class="text-center">Usuario</th>
                                                                <th class="text-center">Tipo usuario</th>
                                                                <th class="text-center">Modelo / Tabla</th>
                                                                <th class="text-center">Detalle cambios</th>
                                                                <th class="text-center">IP</th>
                                                                <th class="text-center">URL</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!-- DataTables llenará el contenido -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('include.footer')
    </div>

    <div class="modal fade" id="modalAuditDetail" tabindex="-1" aria-labelledby="modalAuditDetailLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalAuditDetailLabel">
                        Detalle de auditoría: <span id="auditDetail-event"></span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small">
                        <div><strong>Fecha y hora:</strong> <span id="auditDetail-datetime"></span></div>
                        <div><strong>Usuario:</strong> <span id="auditDetail-user"></span></div>
                        <div><strong>Modelo:</strong> <span id="auditDetail-model"></span></div>
                        <div><strong>IP:</strong> <span id="auditDetail-ip"></span></div>
                        <div class="text-truncate"><strong>URL:</strong> <span id="auditDetail-url"></span></div>
                    </div>

                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <h6 class="text-primary">Valores anteriores (old_values)</h6>
                            <pre id="pre-old-values" class="bg-light border rounded-3 p-2 small" style="max-height: 400px; overflow:auto;"></pre>
                        </div>
                        <div class="col-12 col-md-6">
                            <h6 class="text-primary">Valores nuevos (new_values)</h6>
                            <pre id="pre-new-values" class="bg-light border rounded-3 p-2 small" style="max-height: 400px; overflow:auto;"></pre>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js'])

    <!--  Page JS -->
    @vite(['resources/js/admin/seguridad/auditoria.js'])

</body>

</html>
