<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Items de Titulación</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{-- --}}


    <style>
        /* Evitar que DataTables obligue a que todo sea una sola línea */
        table.dataTable td {
            white-space: normal !important;
        }
    
        /* Solo para columna descripción */
        td.descripcion-col {
            max-width: 300px !important;
            white-space: normal !important;
            word-wrap: break-word !important;
            word-break: break-word !important;
            text-align: justify !important;
        }
    
        /* Para evitar que DataTables la vuelva a estirar */
        table.dataTable {
            table-layout: fixed !important;
        }
    </style>
    
    

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Gestionar Items Titulación
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Items de Titulación</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Item
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Concepto</th>
                                                                <th class="text-center">Descripcion</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Fecha Creacion</th>
                                                                <th class="text-center">Fecha Modificacion</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva Items de Titulación</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">



                        <div class="row">
                            <input id="txt-id" name="txt-id" type="hidden">
                        
                            <!-- Concepto -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="txt-concepto" class="form-label text-primary">Concepto</label>
                                    <input id="txt-concepto" name="txt-concepto" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese concepto" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>
                        
                            <!-- Estado (solo se usa al CREAR, se ocultará en editar) -->
                            <div class="col-md-6" id="col-estado-create">
                                <div class="mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="estado"
                                        class="form-control form-control-sm">
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="1">Activo</option>
                                        <option value="0">Inactivo</option>
                                    </select>
                                    <small class="text-muted">
                                        Si registra el ítem como <strong>Activo</strong>, los documentos asociados
                                        serán visibles para los usuarios autorizados.
                                        Si lo registra como <strong>Inactivo</strong>, los documentos quedarán
                                        como <strong>no visibles</strong>.
                                    </small>
                                </div>
                            </div>
                        
                            <!-- Descripción -->
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <textarea id="txt-descripcion" name="txt-descripcion"
                                        class="form-control form-control-sm"
                                        rows="3"
                                        placeholder="Ingrese descripción" required></textarea>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>
                        </div>
                        
                        
                        





                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>






    <form class="needs-validation" id="formEstado">
        @csrf
        <div id="modalUpdateEstado" class="modal fade" tabindex="-1"
            aria-labelledby="modalUpdateEstadoLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdateEstadoLabel">
                            Actualizar estado del ítem
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <input id="txt-id-estado" name="txt-id-estado" type="hidden">
    
                        <div class="mb-3">
                            <label class="form-label text-primary">Estado</label>
                            <select id="estado-item" name="estado"
                                class="form-control form-control-sm" required>
                                <option selected disabled value="">Seleccione opción</option>
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>
    
                        <small class="text-muted">
                            Al marcar el ítem como <strong>Activo</strong>, los documentos de titulación
                            asociados serán <strong>visibles</strong>.
                            Al marcarlo como <strong>Inactivo</strong>, dichos documentos dejarán de
                            ser <strong>visibles</strong> para los usuarios.
                        </small>
                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdateEstado" type="button"
                            class="btn btn-primary btn-sm">Actualizar estado</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    




    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/seguimiento_egresado/items_titulacion.js'])


</body>

</html>