<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar viaticos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">
        @include('include.nav_header')
        @extends('include.header')
        @section('titlenavbar')
            Gestionar viaticos
        @endsection
        @include('include.sidebar')
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre viaticos</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Viático
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Admin/Docente</th>
                                                                <th class="text-center">Descripcion</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Método de Pago</th>
                                                                <th class="text-center">Banco</th>
                                                                <th class="text-center">N° Operación</th>
                                                                <th class="text-center">Monto</th>
                                                                <th class="text-center">Comprobante</th>
                                                                <th class="text-center">Encargado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar Nuevo Viático</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-2">
                        <!-- ROW 1 -->
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idviatico" name="txt-idviatico" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-usuario_id" class="form-label text-primary">Docente / Administrador</label>
                                    <select id="txt-usuario_id" name="txt-usuario_id" class="default-select form-control form-control-sm" data-live-search="true" data-size="8" required>
                                        <!-- combobox -->
                                        <option selected disabled value="">Buscar usuario</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <input id="txt-descripcion" name="txt-descripcion" type="text"
                                        class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-monto" class="form-label text-primary">Monto</label>
                                    <input id="txt-monto" name="txt-monto" type="number"
                                        class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="1">Pagado</option>
                                        <option value="2">Pendiente</option>
                                        <option value="0">Rechazado</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-metodo_pago_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-metodo_pago_id" class="form-label text-primary">Método de Pago</label>
                                    <select id="txt-metodo_pago_id" name="txt-metodo_pago_id" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-banco_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-banco_id" class="form-label text-primary">Banco</label>
                                    <select id="txt-banco_id" name="txt-banco_id" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-nro_operacion" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nro_operacion" class="form-label text-primary">Número de Operación</label>
                                    <input id="txt-nro_operacion" name="txt-nro_operacion" type="number" class="form-control form-control-sm" placeholder="">
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div id="div-txt-documento" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary">Boucher</label>
                                    <input id="txt-documento" name="txt-documento" type="file" class="form-control form-control-sm" placeholder="">
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light" data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/tesoreria/viaticos.js']);
</body>

</html>
