<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Reportes - Pagos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    {{--     --}}
    <style>
        .chart-pie-small {
            max-width: 360px;
            max-height: 360px;
            width: 100%;
            height: auto;
        }

        .deudores-counter-wrapper {
            display: flex;
            justify-content: center;
        }

        .deudores-counter {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            /* ancho del bloque */
            height: 90px;
            /* alto del bloque */
            background-color: #262626;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
        }

        .deudores-counter__value {
            color: #ffffff;
            font-weight: 700;
            font-size: 2.4rem;
            line-height: 1;
        }

        /* Scroll para la lista */
        .deudores-list {
            max-height: 260px;
            /* ajusta a gusto */
            overflow-y: auto;
        }

        .deudores-list::-webkit-scrollbar {
            width: 6px;
        }

        .deudores-list::-webkit-scrollbar-thumb {
            background-color: rgba(0, 0, 0, 0.15);
            border-radius: 3px;
        }

        .chart-radar {
            max-width: 670px;
            max-height: 450px;
            width: 100%;
            height: auto;
        }
    </style>
</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Reportes de Caja
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="row col-xl-12 m-0 p-0">
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-anho" class="form-label text-primary"><b>
                                            <h4 class="m-0">Año</h4>
                                        </b></label>
                                    <select id="txt-anho" name="txt-anho" class="form-control form-control-sm">
                                        <!-- combobox -->
                                        <option value="" selected disabled>Seleccion opción</option>
                                        <option value="2023">2023</option>
                                        <option value="2024">2024</option>
                                        <option value="2025">2025</option>
                                        <option value="2026">2026</option>
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-mesinicio" class="form-label text-primary"><b>
                                            <h4 class="m-0">Mes Inicio</h4>
                                        </b></label>
                                    <select id="txt-mesinicio" name="txt-mesinicio"
                                        class="form-control form-control-sm">
                                        <!-- combobox -->
                                        <option value="" selected disabled>Seleccion opción</option>
                                        <option value="1">Enero</option>
                                        <option value="2">Febrero</option>
                                        <option value="3">Marzo</option>
                                        <option value="4">Abril</option>
                                        <option value="5">Mayo</option>
                                        <option value="6">Junio</option>
                                        <option value="7">Julio</option>
                                        <option value="8">Agosto</option>
                                        <option value="9">Septiembre</option>
                                        <option value="10">Octubre</option>
                                        <option value="11">Noviembre</option>
                                        <option value="12">Diciembre</option>
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-mesfin" class="form-label text-primary"><b>
                                            <h4 class="m-0">Mes Fin</h4>
                                        </b></label>
                                    <select id="txt-mesfin" name="txt-mesfin" class="form-control form-control-sm">
                                        <option value="" selected disabled>Seleccion opción</option>
                                        <option value="1">Enero</option>
                                        <option value="2">Febrero</option>
                                        <option value="3">Marzo</option>
                                        <option value="4">Abril</option>
                                        <option value="5">Mayo</option>
                                        <option value="6">Junio</option>
                                        <option value="7">Julio</option>
                                        <option value="8">Agosto</option>
                                        <option value="9">Septiembre</option>
                                        <option value="10">Octubre</option>
                                        <option value="11">Noviembre</option>
                                        <option value="12">Diciembre</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                                <div class="card">
                                    <div class="card-body d-flex justify-content-between">
                                        <div class="input-group px-2">
                                            <label class="input-group-text">Ingresos:</label>
                                            <input id="txt-ingresos" name="txt-ingresos" type="text"
                                                class="form-control form-control-select fs-16" readonly>
                                        </div>
                                        <div class="input-group px-2">
                                            <label class="input-group-text">Egresos:</label>
                                            <input id="txt-egresos" name="txt-egresos" type="text"
                                                class="form-control form-control-select fs-16" readonly>
                                        </div>
                                        <div class="input-group px-2">
                                            <label class="input-group-text">Total:</label>
                                            <input id="txt-total" name="txt-total" type="text"
                                                class="form-control form-control-select fs-16" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-6 col-lg-6 col-md-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 p-static pb-2">
                                        <div>
                                            <h6 class="text-center">Reporte por Programas de Estudios</h6>
                                        </div>
                                    </div>
                                    <canvas id="grafico-1" class="p-2"></canvas>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-6 col-lg-6 col-md-6 col-12">
                                <div class="card">
                                    <div class="card-header p-3 d-flex justify-content-between align-items-center">
                                        <h6 class="text-center">Selecciona un Estudiante</h6>
                                        <div>
                                            <select id="txt-students" name="txt-students"
                                                class="form-control form-control-sm" data-live-search="true">
                                                <!-- combobox -->
                                                <option value="" selected disabled>Seleccion un Estudiante
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="card-body tab-content p-3 py-0">
                                        <canvas id="grafico-2" class="p-2"></canvas>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-4 col-lg-4 col-md-4 col-4 mt-3">
                                <div class="card">
                                    <div class="card-header p-3">
                                        <h6 class="text-center mb-0">Reporte por Método de Pago</h6>
                                    </div>
                                    <div class="card-body d-flex justify-content-center">
                                        <canvas id="grafico-3" class="p-2 chart-pie-small"></canvas>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-8 col-lg-8 col-md-4 col-4 mt-3">
                                <div class="card">
                                    <div class="card-header p-3">
                                        <h6 class="text-center mb-0">Resumen Mensual de Deudores</h6>
                                    </div>
                                    <div class="card-body tab-content p-3 py-0">
                                        <canvas id="grafico-4" class="p-2"></canvas>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-3 col-lg-3 col-md-3 col-12 mt-3">
                                <div class="card">
                                    <div class="card-header p-3">
                                        <h6 class="text-center mb-0">Deudores</h6>
                                    </div>
                                    <div class="card-body pt-4">
                                        <div class="deudores-counter-wrapper text-center mb-4">
                                            <div class="deudores-counter">
                                                <span id="cantidad-deudores" class="deudores-counter__value">0</span>
                                            </div>
                                        </div>
                                        <div id="listado-deudores" class="deudores-list">

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-9 col-lg-9 col-md-9 col-12 mt-3">
                                <div class="card">
                                    <div class="card-header p-3">
                                        <h6 class="text-center mb-0">Escala de pensiones</h6>
                                    </div>
                                    <div class="card-body d-flex justify-content-center">
                                        <canvas id="grafico-5" class="p-2 chart-radar"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--**********************************
            Content body end
        ***********************************-->
            @include('include.footer')
        </div>
        <!--**********************************
        Main wrapper end
    ***********************************-->

        <!--**********************************
        Scripts
    ***********************************-->

        @include('include.plugins-scripts')

        @include('include.datatable-scripts')

        <!-- Template JS -->
        <script src="{{ asset('/js/custom.min.js') }}"></script>
        <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


        <!-- Logout JS -->
        <script>
            var logoutRoute = '{{ route('logout') }}';
        </script>
        @vite(['resources/js/login/logout.js']);

        <!--  Page JS -->
        @vite(['resources/js/common/combobox/students.js']);
        @vite(['resources/js/admin/tesoreria/reportes.js']);

</body>

</html>
