<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Notas por cursos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Notas por Unidad Didáctoca
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlplan">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">cursos</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsubject">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="d-flex justify-content-center">
                                                    <button id="btnActaOficial" class="btn btn-primary mx-2" data-bs-placement="top" title="Ver Acta Oficial de Notas">
                                                        Acta Oficial de Notas
                                                    </button>
                                                    <button id="btnActaAuxiliar" class="btn btn-primary mx-2" data-bs-placement="top" title="Ver Acta Auxiliar de Notas">
                                                        Acta Auxiliar de Notas
                                                    </button>
                                                </div>
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">N</th>
                                                                <th class="text-center">Identificación</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Ver Notas</th>
                                                                <th class="text-center">Promedio Final</th>
                                                                <th class="text-center">Estado</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->



                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->



    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalDetalleNotas" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleNotasLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDetalleNotasLabel">Notas del Estudiante: </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralEvaluaciones"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Promedio Final</th>
                                                                <th class="text-center">Indicador</th>
                                                                <th class="text-center">Actividad</th>
                                                                <th class="text-center">Nota</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/common/timeline/semesters.js']);
    @vite(['resources/js/admin/notas/notas_asignaturas.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>
