<!DOCTYPE html>
<html lang="es">

<head>
    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Notas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Gestionar Notas') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlplan">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">cursos</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlsubject">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">DNI</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Nota</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Editar nota</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Editar nota</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idsubjectenrollment" name="txt-idsubjectenrollment" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-curso" class="form-label text-primary">curso</label>
                                    <input id="txt-curso" name="txt-curso" type="text"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estudiante" class="form-label text-primary">Estudiante</label>
                                    <input id="txt-estudiante" name="txt-estudiante" type="text"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nota" class="form-label text-primary">Nota</label>
                                    <input id="txt-nota" name="txt-nota" type="text"
                                        class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button"
                            class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal Crear/Editar Estructura de Nota (Versión Admin) -->
    <form class="needs-validation" id="formModalNotaAdmin" novalidate>
        @csrf
        <div id="modalCU_NotaAdmin" class="modal fade" tabindex="-1" aria-labelledby="modalCU_NotaAdminLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCU_NotaAdminLabel">Gestionar Evaluación</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <!-- IDs ocultos -->
                            <!-- Necesitas setear este ID desde JS cuando abras el modal -->
                            <input type="hidden" id="txt-g_idactivity" name="txt-g_idactivity">
                            <input type="hidden" id="txt-g_idgrade" name="id">

                            <!-- Nombre -->
                            <div class="col-12 mb-3">
                                <label for="txt-g_nombre" class="form-label text-primary">Nombre de la
                                    Evaluación</label>
                                <input type="text" class="form-control form-control-sm" id="txt-g_nombre"
                                    name="txt-g_nombre" required placeholder="Ej. Examen Parcial">
                                <div class="invalid-feedback">El nombre es obligatorio.</div>
                            </div>

                            <!-- Porcentaje -->
                            <div class="col-12 mb-3">
                                <label for="txt-g_porcentaje" class="form-label text-primary">Porcentaje (%)</label>
                                <select id="txt-g_porcentaje" name="txt-g_porcentaje"
                                    class="form-control form-control-sm" required>
                                    <option disabled selected value="">Seleccione porcentaje</option>
                                    <option value="0.05">5%</option>
                                    <option value="0.10">10%</option>
                                    <option value="0.15">15%</option>
                                    <option value="0.20">20%</option>
                                    <option value="0.25">25%</option>
                                    <option value="0.30">30%</option>
                                    <option value="0.35">35%</option>
                                    <option value="0.40">40%</option>
                                    <option value="0.45">45%</option>
                                    <option value="0.50">50%</option>
                                    <option value="0.60">60%</option>
                                    <option value="0.70">70%</option>
                                    <option value="0.80">80%</option>
                                    <option value="0.90">90%</option>
                                    <option value="1.00">100%</option>
                                </select>
                            </div>

                            <!-- Ocultos/Omitidos para el Admin -->
                            <!-- Al no enviarlos, el controlador asumirá: fecha_limite = null, tipo_nota = 0 -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light btn-sm"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button type="button" id="btnCU_NotaAdmin" class="btn btn-primary btn-sm"
                            value="Create">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/notas/nota.js']);
    @vite(['resources/js/common/combobox/classrooms.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
