<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Reservas y Licencias</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Reservas de Matrícula y Licencias
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de reservas / matrículas de estudiantes</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo registro
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">


                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-3">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Tipo de Solicitud</th>
                                                                <th class="text-center">Programa - Plan</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Fecha Inicio</th>
                                                                <th class="text-center">Documento</th>
                                                                <th class="text-center">Pago</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12 m-0 p-0">
                                <!-- data -->
                                <input type="hidden" id="txt-idstudentdocument" name="txt-idstudentdocument">
                                <!-- data -->
                                <div id="div-txt-students" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-students" class="form-label text-primary">Buscar Estudiante</label>
                                    <select id="txt-students" name="txt-students" class="form-control form-control-sm" data-show-subtext="true" data-live-search="true" required>
                                        <option disabled selected value="0">Buscar docente</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_solicitud" class="form-label text-primary">Fecha Solicitud</label>
                                    <input id="txt-fecha_solicitud" name="txt-fecha_solicitud" type="date" class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_inicio" class="form-label text-primary">Fecha Inicio</label>
                                    <input id="txt-fecha_inicio" name="txt-fecha_inicio" type="date" class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Tipo Solicitud</label>
                                    <select id="txt-nombre" name="txt-nombre" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="Reserva de Matricula">Reserva de Matrícula</option>
                                        <option value="Licencia Regular">Licencia Regular</option>
                                        {{-- <option value="Licencia Discapacitado">Licencia Discapacitado</option> --}}
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-document" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-document" class="form-label text-primary">Documento de Resolución</label>
                                    <input id="txt-document" name="txt-document" type="file" class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <textarea class="form-control" id="txt-descripcion" name="txt-descripcion" placeholder="Descripción sobre el proceso de solicitud" rows="3"  required></textarea>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <form class="needs-validation" id="formestado" name="formestado" novalidate>
        @csrf
        <div id="modalupdateestado" class="modal fade" tabindex="-1" aria-labelledby="modalupdateestadoLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalupdateestadoLabel">Actualizar estado de Solicitud</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row">
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <!-- data -->
                                    <input type="hidden" id="txt-idstudentdocument2" name="txt-idstudentdocument2">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado"
                                        class="default-select  form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="0">Inactivo</option>
                                        <option value="1">Activo</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCambiarestado" type="button"
                            class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/common/combobox/students.js']);
    @vite(['resources/js/admin/matricula/reservas_licencias.js']);
</body>

</html>
