<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Estudiantes por Periodo</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Matricular Estudiantes en Periodos Lectivos
        @endsection

        @include('include.sidebar')

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-3">
                        <!-- card -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                    <h2 class="card-title text-light">Programas de Estudios</h2>
                                </div>
                                <div class="card-body p-0">
                                    <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                        <ul id="tlprogram" class="timeline">
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- card -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                    <h2 class="card-title text-light">Planes</h2>
                                </div>
                                <div class="card-body p-0">
                                    <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                        <ul id="tlplan" class="timeline">
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Identificación</th>
                                                                <th class="text-center">Nombres</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Estado Pago</th>
                                                                <th class="text-center">Estado Matricula</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('include.footer')
    </div>

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idsemesterenrollment" name="txt-idsemesterenrollment">
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idstudent" name="txt-idstudent">
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Matricular</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha matricula</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- Modal -->
    <div id="informacionModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="informacionModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="informacionModalLabel">Información del Periodo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="modalLoader" style="display: none;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Cargando...</span>
                        </div>
                    </div>
                    <div id="modalInformacionContent" style="display: none;"></div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
        
        tl_semesters();
        function tl_semesters() {
            $.ajax({
                type: "GET",
                url: '/ajax_all/semesters',
                dataType: 'json',
                beforeSend: function () { },
                success: function (response) {
                    response.forEach((elemento) => {
                        document.getElementById("tlsemester").innerHTML +=
                            "<li class=''>" +
                                "<div class='divsemester timeline-badge primary'></div>" +
                                "<a class='btnSemester timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                                    "data-idsemester='" + elemento.id + "'" +
                                    "data-anho='" + elemento.anho + "'" +
                                    "data-numero='" + elemento.numero + "'" +
                                    "data-fecinicio='" + elemento.fecinicio + "'" +
                                    "data-fecfin='" + elemento.fecfin + "'" +
                                    " > " +
                                    "<div class='d-flex justify-content-between align-items-center w-100'>" +  // Contenedor flex para alinear el h6 y el div
                                        "<h6 class='mb-0 fs-14'>" +
                                            "<strong class='text-primary'>" + elemento.anho + " - " + elemento.numero + "</strong>" +
                                        "</h6>" +
                                        "</div>"
                                    "</div>" +
                                "</a>" +
                            "</li>"
                    });
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/common/timeline/programs.js']);
    @vite(['resources/js/admin/matricula/alumnos_semestre.js']);
</body>

</html>
