<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Periodos Lectivos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}
</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Gestionar Periodos Lectivos
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Periodos Lectivos</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Periodo
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" Aulae="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Creditaje</th>
                                                                <th class="text-center">% Inasistencias</th>
                                                                <th class="text-center">Nota Mínima</th>
                                                                <th class="text-center">Fechas de Matricula</th>
                                                                <th class="text-center">Fechas de Notas</th>
                                                                <th class="text-center">Fechas de Actas</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar Nuevo Periodo</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0 pt-3">
                                <!-- data -->
                                <input id="txt-id" name="txt-id" type="hidden">
                                <input id="txt-estado" name="txt-estado" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-anho" class="form-label text-primary">Año</label>
                                    <input id="txt-anho" name="txt-anho" type="number"
                                        class="form-control form-control-sm" placeholder="Ejm: 2024" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-numero" class="form-label text-primary">Número</label>
                                    <input id="txt-numero" name="txt-numero" type="number"
                                        class="form-control form-control-sm" placeholder="Ejm: 1 o 2" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-tipo" class="form-label text-primary">Tipo</label>
                                    <select id="txt-tipo" name="txt-tipo"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="1">Regular</option>
                                        <option value="2">Vacacional</option>
                                        <option value="3">Reforzamiento</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-creditaje" class="form-label text-primary">Creditaje</label>
                                    <input id="txt-creditaje" name="txt-creditaje" type="number" class="form-control form-control-sm"
                                        placeholder="Ej: 24" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-porcentaje_inasistencias" class="form-label text-primary">% Inasistencias</label>
                                    <input id="txt-porcentaje_inasistencias" name="txt-porcentaje_inasistencias" type="number"
                                        min="1" max="100" class="form-control form-control-sm"
                                        placeholder="Ej: 24" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nota_minima" class="form-label text-primary">Nota Mínima de Aprobacion</label>
                                    <input id="txt-nota_minima" name="txt-nota_minima" type="number"
                                        min="1" max="50" class="form-control form-control-sm"
                                        placeholder="Ej: 24" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                {{-- <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecinicio" class="form-label text-primary">Fecha Inicio</label>
                                    <input id="txt-fecinicio" name="txt-fecinicio" type="date"
                                        class="form-control form-control-sm" >
                                </div> --}}
                                <!-- data -->
                                {{-- <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecfin" class="form-label text-primary">Fecha Fin</label>
                                    <input id="txt-fecfin" name="txt-fecfin" type="date"
                                        class="form-control form-control-sm">
                                </div> --}}
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3" style="display: none;">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-informacion" class="form-label text-primary">Información del proceso</label>
                                        <textarea id="txt-informacion" name="txt-informacion" class="form-control form-control-sm"
                                            placeholder="Ingrese descripción">
                                        </textarea>
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_inicio_matricula" class="form-label text-primary">Inicio Matrícula</label>
                                    <input id="txt-fecha_inicio_matricula" name="txt-fecha_inicio_matricula" type="date"
                                        class="form-control form-control-sm"  required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_fin_matricula" class="form-label text-primary">Cierre Matrícula</label>
                                    <input id="txt-fecha_fin_matricula" name="txt-fecha_fin_matricula" type="date"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_inicio_notas" class="form-label text-primary">Inicio Notas</label>
                                    <input id="txt-fecha_inicio_notas" name="txt-fecha_inicio_notas" type="date"
                                        class="form-control form-control-sm"  required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_fin_notas" class="form-label text-primary">Cierre Notas</label>
                                    <input id="txt-fecha_fin_notas" name="txt-fecha_fin_notas" type="date"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_inicio_actas" class="form-label text-primary">Inicio Actas</label>
                                    <input id="txt-fecha_inicio_actas" name="txt-fecha_inicio_actas" type="date"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha_fin_actas" class="form-label text-primary">Cierre Actas</label>
                                    <input id="txt-fecha_fin_actas" name="txt-fecha_fin_actas" type="date"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        tinymce.init({
            selector: '#txt-informacion',
            // apiKey: '4sh9d8nudkauw4719swn2o8026yhuxdscvzznkyvp2o0wjzg',
        });
        
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/institucion/semestres.js']);

</body>

</html>
