<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Programas de Estudios</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Gestionar Programas de Estudios') }}
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title"><svg xmlns="http://www.w3.org/2000/svg"
                                                height="1em"
                                                viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                <path
                                                    d="M219.3 .5c3.1-.6 6.3-.6 9.4 0l200 40C439.9 42.7 448 52.6 448 64s-8.1 21.3-19.3 23.5L352 102.9V160c0 70.7-57.3 128-128 128s-128-57.3-128-128V102.9L48 93.3v65.1l15.7 78.4c.9 4.7-.3 9.6-3.3 13.3s-7.6 5.9-12.4 5.9H16c-4.8 0-9.3-2.1-12.4-5.9s-4.3-8.6-3.3-13.3L16 158.4V86.6C6.5 83.3 0 74.3 0 64C0 52.6 8.1 42.7 19.3 40.5l200-40zM111.9 327.7c10.5-3.4 21.8 .4 29.4 8.5l71 75.5c6.3 6.7 17 6.7 23.3 0l71-75.5c7.6-8.1 18.9-11.9 29.4-8.5C401 348.6 448 409.4 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3c0-71.9 47-132.7 111.9-153.6z" />
                                            </svg> Programas de Estudios Profesional Técnico</h4>
                                        </div>
                                        <button id="modalCreateUpdate_pt" type="button" class="btn btn-primary btn-sm">
                                            + Nuevo
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive" id="cotainer_inner_dataExcel">
                                                    <table id="datatableGeneral_profesionaTec"
                                                        class="table-stripe table-bordered table-sm display table table-hover"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary thead-rounded-top">
                                                            <tr>
                                                                <th class="text-center">Código</th>
                                                                <th class="text-start">Programa</th>
                                                                <th class="text-center">Acción</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    {{-- <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title"><svg xmlns="http://www.w3.org/2000/svg"
                                                height="1em"
                                                viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                <path
                                                    d="M219.3 .5c3.1-.6 6.3-.6 9.4 0l200 40C439.9 42.7 448 52.6 448 64s-8.1 21.3-19.3 23.5L352 102.9V160c0 70.7-57.3 128-128 128s-128-57.3-128-128V102.9L48 93.3v65.1l15.7 78.4c.9 4.7-.3 9.6-3.3 13.3s-7.6 5.9-12.4 5.9H16c-4.8 0-9.3-2.1-12.4-5.9s-4.3-8.6-3.3-13.3L16 158.4V86.6C6.5 83.3 0 74.3 0 64C0 52.6 8.1 42.7 19.3 40.5l200-40zM111.9 327.7c10.5-3.4 21.8 .4 29.4 8.5l71 75.5c6.3 6.7 17 6.7 23.3 0l71-75.5c7.6-8.1 18.9-11.9 29.4-8.5C401 348.6 448 409.4 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3c0-71.9 47-132.7 111.9-153.6z" />
                                            </svg> Programas de Estudios Técnico</h4>
                                        </div>
                                        <button id="modalCreateUpdate_p" type="button" class="btn btn-primary btn-sm">
                                            + Nuevo
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive" id="cotainer_inner_dataExcel">
                                                    <table id="datatableGeneral_tecnico"
                                                        class="table-stripe table-bordered table-sm display table table-hover"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary thead-rounded-top">
                                                            <tr>
                                                                <th class="text-center">Código</th>
                                                                <th class="text-start">Programa</th>
                                                                <th class="text-center">Acción</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div> --}}
                </div>
            </div>
        </div>
        <form class="needs-validation" id="formModalcatalogoprogramasproftec" name="formModalcatalogoprogramasproftec" novalidate>
            @csrf
            <div id="modalcatalogoprogramasproftec" class="modal fade" tabindex="-1" aria-labelledby="modalcatalogoprogramasproftecLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalcatalogoprogramasproftecLabel"> </h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutBorder" role="tabpanel"
                                    aria-labelledby="home-tab-2">
                                    <div class="card-body p-0">
                                        <div class="table-responsive">
                                            <table id="datatableGeneralcatalogoprogramasproftec"
                                            class="table table-hover table-bordered table-sm display rounded-3"
                                                                style="min-width:100%;font-size:12px">

                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Código</th>
                                                        <th class="text-center">Programa</th>
                                                        <th class="text-center">Años</th>
                                                        <th class="text-center">Registrar</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <form class="needs-validation" id="formModalcatalogoprogramastec" name="formModalcatalogoprogramastec" novalidate>
            @csrf
            <div id="modalcatalogoprogramastec" class="modal fade" tabindex="-1" aria-labelledby="modalcatalogoprogramastecLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalcatalogoprogramastecLabel"> </h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutBorder" role="tabpanel"
                                    aria-labelledby="home-tab-2">
                                    <div class="card-body p-0">
                                        <div class="table-responsive">
                                            <table id="datatableGeneralcatalogoprogramastec"
                                            class="table table-hover table-bordered table-sm display rounded-3"
                                                                style="min-width:100%; font-size:12px">

                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Código</th>
                                                        <th class="text-center">Programa</th>
                                                        <th class="text-center">Años</th>
                                                        <th class="text-center">Registrar</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    <script>
        var routeListproftec = "{{ route('admin.institucion.programas.list.prof.tec') }}";
        var routeListtec= "{{ route('admin.institucion.programas.list.tec') }}";
        var routeStore = "{{ route('admin.institucion.programas.store') }}";
      </script>
    @vite(['resources/js/admin/institucion/programas_proftec.js']);
    @vite(['resources/js/admin/institucion/programas_tec.js']);
</body>

</html>
