<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Instituciones Externas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{-- --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Gestionar Instituciones Externas
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Instituciones Externas</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Institucion Externa
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Direccion</th>
                                                                <th class="text-center">Contacto</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva Institucion Externa</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <div class="row">
                            <input id="txt-id" name="txt-id" type="hidden">

                            <!-- columna izquierda -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="txt-name" class="form-label text-primary">Nombre</label>
                                    <input id="txt-name" name="txt-name" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <div class="mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Direccion</label>
                                    <input id="txt-direccion" name="txt-direccion" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>

                            <!-- columna derecha -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="txt-contact_number" class="form-label text-primary">Contacto</label>
                                    <input id="txt-contact_number" name="txt-contact_number" type="number"
                                        class="form-control form-control-sm" placeholder="Ejm: 999888777" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <div class="mb-3">
                                    <label for="txt-email" class="form-label text-primary">Correo</label>
                                    <input id="txt-email" name="txt-email" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: institucion-ejemplo@gmail.com"
                                        required>
                                    @include('include.div.invalid-feedback')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>




    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/institucion/instituciones.js'])

</body>

</html>