<!DOCTYPE html>
<html lang="es">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @include('include.meta-favicon')
    @include('include.plugins-styles')
    <title>Información Institucional</title>
    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>

    @include('include.preloader')
    <!--**********************************
        Main wrapper start
    ***********************************-->

    <div id="main-wrapper">
        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Información Institucional
        @endsection

        @include('include.sidebar')

        <!--**********************************
        Content body start
    ***********************************-->
        <div class="content-body">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Información institucional</h4>
                            </div>

                            <div class="card-body">
                                <form id="formInfo" class="needs-validation" novalidate>
                                    @csrf
                                    @method('PUT')

                                    <div class="mb-3">
                                        <label class="form-label">Nombre</label>
                                        <input type="text" id="nombre" name="nombre" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Logo</label>
                                        <div class="input-group">
                                            <input type="file" id="logoFile" accept="image/*" class="form-control">
                                        </div>
                                        <img id="logoPreview" class="img-fluid mt-2 d-none" style="max-height:120px">
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Dirección</label>
                                        <input type="text" id="direccion" name="direccion" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Contacto</label>
                                        <input type="text" id="contacto" name="contacto" class="form-control"
                                            required>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <button type="button" id="btnGuardarInfo"
                                            class="btn btn-primary btn-sm">Guardar
                                            cambios</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                @push('scripts')
                    <script>
                        function previewLogo(e) {
                            const file = e.target.files[0];
                            if (file) {
                                const reader = new FileReader();
                                reader.onload = function(ev) {
                                    const img = document.getElementById('logoPreview');
                                    img.src = ev.target.result;
                                    img.classList.remove('d-none');
                                };
                                reader.readAsDataURL(file);
                            }
                        }
                    </script>
                @endpush
            </div>
        </div>
        <!--**********************************
        Content body end
    ***********************************-->

        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    @include('include.plugins-scripts')
    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js'])
    @vite(['resources/js/admin/institucion/info_instita.js'])
</body>

</html>
