<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Horario x Periodo</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
</head>

<body>
    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')

        @section('titlenavbar')
            {{ __('Horarios por Periodo') }}
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlplan">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!--  -->
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Código</th>
                                                                <th class="text-center">Nombre curso</th>
                                                                {{-- <th class="text-center">Turno</th> --}}
                                                                <th class="text-center">Seccion</th>
                                                                {{-- <th class="text-center">Creditos</th>
                                                                <th class="text-center">Horas</th> --}}
                                                                <th class="text-center">P. A.</th>
                                                                <th class="text-center">Lunes</th>
                                                                <th class="text-center">Martes</th>
                                                                <th class="text-center">Miercoles</th>
                                                                <th class="text-center">Jueves</th>
                                                                <th class="text-center">Viernes</th>
                                                                <th class="text-center">Sabado</th>
                                                                <th class="text-center">Docente</th>
                                                                <th class="text-center">Aula</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>


    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idperiod" name="txt-idperiod">
    </form>

    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/horarios/horario_general.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>
