<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    <meta name="csrf-token" content="{{ csrf_token() }}">

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Traslados</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Gestión de Traslados
        @endsection

        @include('include.sidebar')


        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de Traslados</h4>
                                        </div>
                                        <button id="btnNuevoTraslado" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalNuevoTraslado">
                                            + Nuevo Traslado
                                        </button>
                                    </div>
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Nro. Ident.</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Origen</th>
                                                                <th class="text-center">Destino</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Archivo</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('include.footer')

    </div>
    <div class="modal fade" id="modalNuevoTraslado" tabindex="-1" aria-labelledby="modalNuevoTrasladoLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-primary text-white py-2 px-3">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="modalNuevoTrasladoLabel">
                        <i class="fas fa-user-plus"></i> Formulario de nuevo traslado
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>

                <form id="formNuevoTraslado" class="needs-validation" novalidate enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="student_id" id="student_id">

                    <div class="modal-body p-3">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="nro_documento">Nro Documento <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="nro_documento_busqueda"
                                        placeholder="Buscar por DNI/CE..." required>
                                    <button class="btn btn-primary" type="button" id="btnBuscarDocumento">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <div class="invalid-feedback">Ingrese un número de documento.</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="nombre_estudiante">Estudiante</label>
                                <input type="text" class="form-control" id="nombre_estudiante" readonly
                                    placeholder="(Resultados de la búsqueda)">
                            </div>

                            <hr class="my-2">

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="tipo">Tipo de Traslado <span
                                        class="text-danger">*</span></label>
                                <select id="tipo" name="tipo" class="form-control selectpicker"
                                    title="Seleccione un tipo" required>
                                    <option value="Ingreso">Ingreso</option>
                                    <option value="Salida">Salida</option>
                                </select>
                                <div class="invalid-feedback">Seleccione un tipo.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="fecha">Fecha de Traslado <span
                                        class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="fecha" name="fecha" required>
                                <div class="invalid-feedback">Ingrese una fecha.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="institucion_origen">Institución de Origen
                                    <span class="text-danger">*</span></label>
                                <select id="institucion_origen" name="institucion_origen"
                                    class="form-control selectpicker" data-live-search="true"
                                    title="Seleccione origen" required>
                                </select>
                                <div class="invalid-feedback">Seleccione una institución.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="carrera_origen">Carrera de Origen <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="carrera_origen" name="carrera_origen"
                                    required>
                                <div class="invalid-feedback">Ingrese la Carrera de origen.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="institucion_destino">Institución de Destino
                                    <span class="text-danger">*</span></label>
                                <select id="institucion_destino" name="institucion_destino"
                                    class="form-control selectpicker" data-live-search="true"
                                    title="Seleccione destino" required>
                                </select>
                                <div class="invalid-feedback">Seleccione una institución.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="carrera_destino">Carrera de Destino <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="carrera_destino"
                                    name="carrera_destino" required>
                                <div class="invalid-feedback">Ingrese la Carrera de destino.</div>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label fw-semibold" for="archivo">Archivo (Resolución,
                                    etc.)</label>
                                <input id="archivo" name="archivo" type="file" class="form-control"
                                    accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                <div class="form-text">Adjunte el documento de respaldo (Opcional).</div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button id="btnGuardarTraslado" type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalEditarTraslado" tabindex="-1" aria-labelledby="modalEditarTrasladoLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-warning text-white py-2 px-3">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="modalEditarTrasladoLabel">
                        <i class="fas fa-pencil-alt"></i> Formulario de Edición de Traslado
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>

                <form id="formEditarTraslado" class="needs-validation" novalidate enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="student_id" id="student_id_edit">
                    <input type="hidden" name="traslado_id" id="traslado_id_edit">

                    <div class="modal-body p-3">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="nro_documento_edit">Nro Documento</label>
                                <input type="text" class="form-control" id="nro_documento_edit" readonly>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="nombre_estudiante_edit">Estudiante</label>
                                <input type="text" class="form-control" id="nombre_estudiante_edit" readonly>
                            </div>

                            <hr class="my-2">

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="tipo_edit">Tipo de Traslado <span
                                        class="text-danger">*</span></label>
                                <select id="tipo_edit" name="tipo" class="form-control selectpicker"
                                    title="Seleccione un tipo" required>
                                    <option value="Ingreso">Ingreso</option>
                                    <option value="Salida">Salida</option>
                                </select>
                                <div class="invalid-feedback">Seleccione un tipo.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="fecha_edit">Fecha de Traslado <span
                                        class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="fecha_edit" name="fecha" required>
                                <div class="invalid-feedback">Ingrese una fecha.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="institucion_origen_edit">Institución de
                                    Origen
                                    <span class="text-danger">*</span></label>
                                <select id="institucion_origen_edit" name="institucion_origen"
                                    class="form-control selectpicker" data-live-search="true"
                                    title="Seleccione origen" required>
                                </select>
                                <div class="invalid-feedback">Seleccione una institución.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="carrera_origen_edit">Carrera de Origen
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="carrera_origen_edit"
                                    name="carrera_origen" required>
                                <div class="invalid-feedback">Ingrese la Carrera de origen.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="institucion_destino_edit">Institución de
                                    Destino
                                    <span class="text-danger">*</span></label>
                                <select id="institucion_destino_edit" name="institucion_destino"
                                    class="form-control selectpicker" data-live-search="true"
                                    title="Seleccione destino" required>
                                </select>
                                <div class="invalid-feedback">Seleccione una institución.</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="carrera_destino_edit">Carrera de Destino
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="carrera_destino_edit"
                                    name="carrera_destino" required>
                                <div class="invalid-feedback">Ingrese la Carrera de destino.</div>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label fw-semibold" for="archivo_edit">Cambiar Archivo
                                    (Opcional)</label>
                                <input id="archivo_edit" name="archivo" type="file" class="form-control"
                                    accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                <div class="form-text">Suba un nuevo archivo solo si desea reemplazar el existente.
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button id="btnGuardarEdicion" type="submit" class="btn btn-warning">
                            <i class="fas fa-save"></i> Actualizar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="modalViewDocument" tabindex="-1" aria-labelledby="modalViewDocumentLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-primary text-white py-2 px-3">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="modalViewDocumentLabel">
                        <i class="fas fa-file-alt"></i>
                        <span id="documentTitle">Visualizar Documento</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body p-0">
                    <div class="container-fluid p-0">
                        <div id="unsupportedAlert" class="alert alert-warning m-3 d-none">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span id="unsupportedMessage">Este tipo de archivo no puede visualizarse en el
                                navegador.</span>
                        </div>

                        <div id="documentViewer" class="d-none">
                            <div id="pdfViewer" class="d-none w-100">
                                <iframe id="pdfFrame" src="" class="w-100"
                                    style="height: 70vh; border: none;" frameborder="0">
                                </iframe>
                            </div>
                            <div id="imageViewer" class="d-none text-center">
                                <img id="imageFrame" src="" class="img-fluid" style="max-height: 70vh;"
                                    alt="Documento visualizado">
                            </div>
                        </div>

                        <div class="card border-0 bg-light m-3">
                            <div class="card-body py-2">
                                <div class="row">
                                    <div class="col-md-8">
                                        <small class="text-muted">
                                            <i class="fas fa-file me-1"></i>
                                            <strong id="fileNameInfo">-</strong>
                                        </small>
                                    </div>
                                    <div class="col-md-4 text-end">
                                        <a id="downloadLink" href="#" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-download me-1"></i>Descargar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times"></i> Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    @vite(['resources/js/admin/estudiantes/traslados.js']);

</body>

</html>
