<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Cursos</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{-- --}}

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Gestionar cursos en un periodo lectivo
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">periodo lectivo</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Plan de estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlplan">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Semestre Academico</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlperiod">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Ud. Didáctica</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Creditos y Horas</th>
                                                                <th class="text-center">Sección</th>
                                                                <th class="text-center">Turno</th>
                                                                <th class="text-center">Condicion</th>
                                                                <th class="text-center">Cupos</th>
                                                                <th class="text-center">Silabo</th>
                                                                <th class="text-center">Inst. Evaluación</th>
                                                                <th class="text-center">Docente</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->



                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idcourse" name="txt-idcourse">
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-newseccion" name="txt-newseccion">
    </form>



    <!-- Modal Buscar Docente -->
    <form id="formModal2" novalidate>
        @csrf
        <div class="modal fade" id="modalBuscarDocente">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Buscar Docente</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                        </button>
                    </div>
                    <div class="modal-body">
                        <!--  -->
                        <div class="col-sm-12">
                            <select id="txt-teachers" class="form-control" data-show-subtext="true"
                                data-live-search="true" required>
                                <option disabled selected value="0">Buscar docente</option>
                            </select>
                        </div>
                        <hr>
                        <!--  -->
                        <input type="hidden" id="txt-idteacher" name="txt-idteacher">
                        <h5 class="text-center">Info Docente</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Código</strong>
                                <span id="dt-doc-coddocente" class="mb-0">--</span>
                            </li>
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Apellidos y Nombres</strong>
                                <span id="dt-doc-apenom" class="mb-0">--</span>
                            </li>
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Contacto</strong>
                                <span id="dt-doc-contacto" class="mb-0">--</span>
                            </li>
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Tipo Contrato</strong>
                                <span id="dt-doc-tipocontrato" class="mb-0">--</span>
                            </li>
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Horas lectivas</strong>
                                <span id="dt-doc-horas_lectivas" class="mb-0">--</span>
                            </li>
                        </ul>
                        <hr>
                        <!--  -->
                        <input type="hidden" id="txt-idsubject" name="txt-idsubject">
                        <h5 class="text-center">Info U. D.</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex px-0 justify-content-between">
                                <strong>Nombre</strong>
                                <span id="dt-sub-nombre" class="mb-0">--</span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger light" data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnAssign" type="button" class="btn btn-primary">Asignar Docente</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal Actualizar curso -->
    <form id="formModal3" novalidate>
        @csrf
        <div id="modalUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalUpdateLabel">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdateLabel">Actualizar curso</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-nomcurso" class="form-label text-primary">curso</label>
                                    <input id="txt-nomcurso" name="txt-nomcurso" type="text"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3" style="display: none;">
                                    <label for="txt-nota_minima" class="form-label text-primary">Nota Minima</label>
                                    <input id="txt-nota_minima" name="txt-nota_minima" type="text" value="13"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-seccion" class="form-label text-primary">Seccion</label>
                                    <select id="txt-seccion" name="txt-seccion"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.subject_seccion')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-turno" class="form-label text-primary">Turno</label>
                                    <select id="txt-turno" name="txt-turno"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.subject_turno')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-sub_tipo" class="form-label text-primary">Tipo</label>
                                    <select id="txt-sub_tipo" name="txt-sub_tipo"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.subject_tipo')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-cupos" class="form-label text-primary">N° Cupos</label>
                                    <input id="txt-cupos" name="txt-cupos" type="text"
                                        class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div id="div-txt-silabo" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-silabo" class="form-label text-primary">Sílabo</label>
                                    <input id="txt-silabo" name="txt-silabo" type="file"
                                        class="form-control form-control-sm">
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div id="div-txt-instrumentos_evaluacion"
                                    class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-instrumentos_evaluacion"
                                        class="form-label text-primary">Instrumentos de Evaluación</label>
                                    <input id="txt-instrumentos_evaluacion" name="txt-instrumentos_evaluacion"
                                        type="file" class="form-control form-control-sm">
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal Análisis de Rendimiento -->
    <div class="modal fade" id="modalAnalisisRendimiento" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">

                <!-- HEADER -->
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-chart-line me-2"></i>
                        Análisis de Rendimiento - <span id="cursoNombreModal">Unidad Didáctica X - Sección A</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <!-- BODY -->
                <div class="modal-body">

                    <!-- MÉTRICAS RESUMEN -->
                    <div class="row text-center mb-4">
                        <div class="col-md-3">
                            <div class="card shadow-sm border-0">
                                <div class="card-body">
                                    <h6>Total Estudiantes</h6>
                                    <h3 id="metricTotal">0</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card shadow-sm border-0">
                                <div class="card-body">
                                    <h6>Promedio General</h6>
                                    <h3 id="metricPromedio">0.00</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card shadow-sm border-0">
                                <div class="card-body">
                                    <h6>% Aprobación</h6>
                                    <h3 id="metricAprobacion">0%</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card shadow-sm border-0">
                                <div class="card-body">
                                    <h6>Nota Mínima</h6>
                                    <h3 id="metricNotaMinima">11</h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- NAV TABS -->
                    <ul class="nav nav-tabs mb-3" id="tabsAnalisis" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tabGraficos"
                                type="button" role="tab">
                                Gráficos
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabEstudiantes" type="button"
                                role="tab">
                                Lista de Estudiantes
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabRiesgo" type="button"
                                role="tab">
                                Estudiantes en Riesgo
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabIndicadores" type="button"
                                role="tab">
                                Evaluación por Indicadores
                            </button>
                        </li>
                    </ul>

                    <!-- TAB CONTENT -->
                    <div class="tab-content">

                        <!-- En la sección de gráficos del modal, reemplaza con esto: -->
                        <div class="tab-pane fade show active" id="tabGraficos" role="tabpanel">
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="card shadow-sm border-0">
                                        <div class="card-body">
                                            <div style="position: relative; height: 300px; width: 100%;">
                                                <canvas id="graficoDistribucion"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="card shadow-sm border-0">
                                        <div class="card-body">
                                            <div style="position: relative; height: 250px; width: 100%;">
                                                <canvas id="graficoEstado"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TAB: LISTA DE ESTUDIANTES -->
                        <div class="tab-pane fade" id="tabEstudiantes" role="tabpanel">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm" id="tablaEstudiantes">
                                    <thead class="table-primary">
                                        <tr>
                                            <th>Estudiante</th>
                                            <th>Código</th>
                                            <th>Nota Final</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="4" class="text-center">Cargando...</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- TAB: ESTUDIANTES EN RIESGO -->
                        <div class="tab-pane fade" id="tabRiesgo" role="tabpanel">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm" id="tablaRiesgo">
                                    <thead class="table-danger">
                                        <tr>
                                            <th>Estudiante</th>
                                            <th>Código</th>
                                            <th>Nota</th>
                                            <th>Eval. Bajas</th>
                                            <th>Asist. Bajas</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="6" class="text-center">Cargando...</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- TAB: INDICADORES -->
                        <div class="tab-pane fade" id="tabIndicadores" role="tabpanel">
                            <div class="table-responsive mb-3">
                                <table class="table table-bordered table-sm" id="tablaIndicadores">
                                    <thead class="table-secondary">
                                        <tr>
                                            <th>Indicador</th>
                                            <th>Actividades</th>
                                            <th>% Total</th>
                                            <th>Promedio</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="5" class="text-center">Cargando...</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Detalle de Actividades -->
                            <div id="detalleActividades" style="display:none;">
                                <h6 class="text-primary">Detalle de Actividades</h6>
                                <table class="table table-bordered table-sm" id="tablaActividades">
                                    <thead>
                                        <tr>
                                            <th>Actividad</th>
                                            <th>Evaluación</th>
                                            <th>%</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>

                    </div> <!-- /TAB CONTENT -->

                </div>

                <!-- FOOTER -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Cerrar
                    </button>
                </div>

            </div>
        </div>
    </div>

    <style>
        /* Agregar en tu CSS existente */
        .chart-container {
            position: relative;
            margin: auto;
        }

        #graficoDistribucion {
            max-height: 300px !important;
        }

        #graficoEstado {
            max-height: 250px !important;
        }

        /* Asegurar que el modal tenga suficiente espacio */
        #modalAnalisisRendimiento .modal-xl {
            max-width: 1200px;
        }

        #modalAnalisisRendimiento .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }
    </style>


    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/common/timeline/semesters.js']);
    @vite(['resources/js/common/combobox/teachers.js']);
    @vite(['resources/js/admin/portafolio_cursos/asignaturas.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>