<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Constancias y Certificados</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{-- --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Constancias y Certificados
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-4 col-sm-12 col-12 mb-3">
                                    <label for="txt-programs" class="form-label text-primary"><b>
                                            <h4>Seleccione un Programa</h4>
                                        </b></label>
                                    <select id="txt-programs" name="txt-programs" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-4 col-sm-12 col-12 mb-3">
                                    <label for="txt-plans" class="form-label text-primary"><b>
                                            <h4>Seleccione un Plan</h4>
                                        </b></label>
                                    <select id="txt-plans" name="txt-plans" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <option value="" selected disabled>Seleccione una opción</option>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-4 col-sm-12 col-12 mb-3">
                                    <label for="txt-students" class="form-label text-primary"><b>
                                            <h4>Seleccione un Estudiante</h4>
                                        </b></label>
                                    <select id="txt-students" name="txt-students" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <option value="" selected disabled>Seleccione una opción</option>
                                        <!-- combobox -->
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <h4 class="card-title">Record Académico del estudiante</h4>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-3">
                                                <div class="d-flex justify-content-center pb-3">
                                                    <button id="btnRecordNotas" class="btn btn-primary mx-2"
                                                        data-bs-placement="top" title="Ver Record de Notas">
                                                        Record de Notas
                                                    </button>
                                                    <button id="btnCertificadoEstudios" class="btn btn-primary mx-2"
                                                        data-bs-placement="top" title="Ver Certificado de Estudios">
                                                        Certificado de Estudios
                                                    </button>
                                                    <button id="btnConstanciaEgresado" class="btn btn-primary mx-2"
                                                        data-bs-placement="top" title="Ver Constancia de Egresado">
                                                        Constancia de Egresado
                                                    </button>
                                                    <button id="btnDiplomaEstudios" class="btn btn-primary mx-2"
                                                        data-bs-placement="top" title="Ver Diploma de Estudios">
                                                        Diploma de Estudios
                                                    </button>
                                                </div>
                                                <div class="table-responsive">
                                                    <table id="datatableGeneralRecordAcademico"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                {{-- <th class="text-center">PLAN</th> --}}
                                                                <th class="text-center">MODULO</th>
                                                                <th class="text-center">PERIODO</th>
                                                                <th class="text-center">CODIGO</th>
                                                                <th class="text-center">NOMBRE DE Unidad Didáctica</th>
                                                                <th class="text-center">CREDITOS</th>
                                                                <th class="text-center">HORAS</th>
                                                                {{-- <th class="text-center">SECCION</th> --}}
                                                                {{-- <th class="text-center">TURNO</th> --}}
                                                                <th class="text-center">SEMESTRE</th>
                                                                <th class="text-center">NOTA</th>
                                                                <th class="text-center">ESTADO</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="validationWarningModal" tabindex="-1" aria-labelledby="validationWarningModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="validationWarningModalLabel">
                            <i class="fa-solid fa-triangle-exclamation text-warning me-2"></i> No se puede generar el
                            documento
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Se encontraron las siguientes observaciones que impiden la emisión:</p>
                        <ul id="validation-errors-list" class="list-group">
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="certificateModal" tabindex="-1" aria-labelledby="certificateModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="certificateModalLabel">Certificado Modular</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body p-0" style="height: 80vh;">
                        <iframe id="certificateIframe" src="" frameborder="0" width="100%"
                            height="100%"></iframe>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <a id="downloadCertificateBtn" href="#" class="btn btn-primary" download>
                            <i class="fa fa-download me-2"></i>Descargar
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
    </form>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/consulta/contancias_certificados.js']);

    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>
