<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Citas Médicas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Gestionar Citas
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Citas</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Cita
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha Cita</th>
                                                                <th class="text-center">Tipo de Cita</th>
                                                                <th class="text-center">Paciente</th>
                                                                <th class="text-center">Especialista</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva Cita</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idappointment" name="txt-idappointment" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date" class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-hora_ini" class="form-label text-primary">Hora de Inicio</label>
                                    <input id="txt-hora_ini" name="txt-hora_ini" type="time" class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-hora_fin" class="form-label text-primary">Hora de Fin</label>
                                    <input id="txt-hora_fin" name="txt-hora_fin" type="time" class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-patient_id" class="form-label text-primary">Paciente</label>
                                    <select id="txt-patient_id" name="txt-patient_id" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-appointment_type_id" class="form-label text-primary">Tipo de Cita</label>
                                    <select id="txt-appointment_type_id" name="txt-appointment_type_id" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <textarea id="txt-descripcion" name="txt-descripcion" type="text" class="form-control form-control-sm" rows="5" required></textarea>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-specialist_id" class="form-label text-primary">Especialista</label>
                                    <select id="txt-specialist_id" name="txt-specialist_id" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-classroom_id" class="form-label text-primary">Ambiente</label>
                                    <select id="txt-classroom_id" name="txt-classroom_id" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display:none">
                                    <label for="txt-motivo_cancelacion" class="form-label text-primary">Motivo de Cancelación</label>
                                    <input id="txt-motivo_cancelacion" name="txt-motivo_cancelacion" type="text" class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado_cita" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado_cita" name="txt-estado_cita" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="0">No Atendida</option>
                                        <option value="1">Atendida</option>
                                        <option value="2">Cancelada</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form class="needs-validation" id="formModal2">
        @csrf
        <div id="modalAttention" class="modal fade" tabindex="-1" aria-labelledby="modalAttentionLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalAttentionLabel">Datos de la atención médica</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-appointment_id" name="txt-appointment_id" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado_atencion" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado_atencion" name="txt-estado_atencion" class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="1">Sin Diagnóstico</option>
                                        <option value="2">Tratamiento Concluido</option>
                                        <option value="3">Referido a Especialista</option>
                                        <option value="4">Estado Normal o Sin Alteraciones</option>
                                        <option value="5">Enfermedad Confirmada</option>
                                        <option value="6">En Observación o Pendiente</option>
                                        <option value="7">Estado Crítico o Grave</option>
                                        <option value="8">Estado Estable</option>
                                        <option value="9">Empeoramiento o Complicación</option>
                                        <option value="10">Recuperación o Mejoría</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-diagnostico" class="form-label text-primary">Diagnostico</label>
                                    <textarea id="txt-diagnostico" name="txt-diagnostico" type="text" class="form-control form-control-sm" rows="3" required></textarea>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-tratamiento" class="form-label text-primary">Tratamiento / Receta</label>
                                    <textarea id="txt-tratamiento" name="txt-tratamiento" type="text" class="form-control form-control-sm" rows="7" required></textarea>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-observacion" class="form-label text-primary">Observación (Opcional)</label>
                                    <textarea id="txt-observacion" name="txt-observacion" type="text" class="form-control form-control-sm" rows="5"></textarea>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal2" type="button" class="btn btn-danger  btn-sm light" data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnAttention" type="button" class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/common/combobox/appointment_types.js'])
    @vite(['resources/js/admin/centro_medico/citas.js'])

</body>

</html>
