<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Bolsa Laboral - Empresas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Bolsa Laboral - Empresas
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de empresas para la Bolsa Laboral</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Empresa
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">RUC</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Dirección</th>
                                                                <th class="text-center">Nro. Contacto</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Usuario</th>
                                                                <th class="text-center">Logo</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva empresa</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt-idcompany" name="txt-idcompany" type="hidden">
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-ruc" class="form-label text-primary">RUC</label>
                                    <div class="input-group">
                                        <input class="form-control form-control-sm" id="txt-ruc" name="txt-ruc"
                                            placeholder="Ingrese RUC" autocomplete="off"
                                            onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                            maxlength="11" type="text" required>
                                        {{-- mensaje de error campo vacio --}}
                                        <button class="btn btn-primary btn-sm" type="button" id="btn-querydata"><i
                                                class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                            Validar
                                        </button>
                                        @include('include.div.invalid-feedback')
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-nombre" name="txt-nombre" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nrocontacto" class="form-label text-primary">Nro. de
                                        Contacto</label>
                                    <input id="txt-nrocontacto" name="txt-nrocontacto" type="text"
                                        class="form-control form-control-sm" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57' maxlength="9"
                                        placeholder="Ingrese celular o teléfono" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-activo" class="form-label text-primary">Activo</label>
                                    <select id="txt-activo" name="txt-activo"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.bit')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt-direccion" name="txt-direccion" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese direccion" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-user" class="form-label text-primary">Nombre de usuario</label>
                                    <input id="txt-user" name="txt-user" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre de usuario"
                                        required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div id="div-txt-password" class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-password" class="form-label text-primary">Contraseña</label>
                                    <input id="txt-password" name="txt-password" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <form id="formModal2" novalidate>
        @csrf
        <div id="modalUpdatePassword" class="modal fade" tabindex="-1" aria-labelledby="modalUpdatePasswordLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar
                            Contraseña</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_idcompany2" name="txt_idcompany2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_ruc2" class="form-label text-primary">#
                                        RUC</label>
                                    <input id="txt_ruc2" name="txt_ruc2" type="text"
                                        class="form-control form-control-sm" required readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nombre2" class="form-label text-primary">Apellidos
                                        y Nombres</label>
                                    <input id="txt_nombre2" name="txt_nombre2" type="text"
                                        class="form-control form-control-sm" required readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password2" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password2" name="txt_password2" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    <div class="invalid-feedback"> Ingrese una contraseña</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePassword" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/admin/bolsa_laboral/empresas.js']);

</body>

</html>
